
<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Category</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="<?php echo e(url('category')); ?>">Category</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col text-lg-end mb-3">
                    <a href="<?php echo e(route('category.create')); ?>" class="btn btn-primary"> <i class="fa fa-plus me-2"
                            aria-hidden="true"></i>+ Add New Category</a>
                </div>
                <div class="row g-3 clearfix row-deck mb-3">
                    <div class="col-lg-12 col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <form class="row g-3" id="filter_form">
                                    <div class="row">
                                        <div class="col-md-3 mt-3">
                                            <label class="form-label"> Category Name</label>
                                            <input type="text" class="form-control" id="category_name" name="category_name"
                                                placeholder="Category Name">
                                        </div>                                    
                                        <div class="col-md-4" style="padding-top:2.5rem;">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn bg-primary btn-xs text-white"
                                                id="filterBtn"><i class="ri-search-line search-icon"></i></button>
                                            <button type="button" class="btn bg-danger btn-xs text-white "
                                                id="resetfilterBtn">X</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1">Category </h5>
                            </div>
                            <div class="card-body">
                                <table id="thisTable" class="table nowrap align-middle" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>SR No.</th>
                                            <th>Category</th>
                                            <th>Icon</th>
                                            <th>Position</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script>
        var tableX = $('#thisTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo e(url('category-filter')); ?>",
                data: function(d) {
                    d.category_name = $('#category_name').val();
                    
                }
            },
            "columns": [

                {
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'category_name',
                    name: 'category_name'
                },                
                {
                    data: 'icon',
                    name: 'icon'
                }, 
                {
                    data: 'position',
                    name: 'position'
                },             
                {
                    data: 'action',
                    name: 'action'
                },
            ],            
            responsive: true,
            "searching": false,
            "bStateSave": true,
            "bAutoWidth": false,
            "ordering": true,
        });

        $('#filterBtn').on('click', function() {
            tableX.draw();
        });
        $('#resetfilterBtn').on('click', function() {
            $('#category_name').val('');
            tableX.draw();
        });

        $(document).on('click', '.delete-button', function() {
            var thisel = $(this).val();
            let id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((data) => {
                if (data.isConfirmed) {
                    Swal.fire(
                        'Deleted!',
                        'Your file has been deleted.',
                        'success'
                    )
                    $.ajax({
                        url: "<?php echo e(url('category')); ?>/" + thisel,
                        type: 'DELETE',
                        data: {
                            '_token': "<?php echo e(csrf_token()); ?>"
                        },
                        success: function(data) {
                            location.reload();
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u454682888/domains/esmagroup.online/public_html/tool/resources/views/admin/category/index.blade.php ENDPATH**/ ?>