
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Testimonials</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                                    <li class="breadcrumb-item active">Testimonials</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col text-lg-end mb-3">
                    <a href="<?php echo e(route('testimonials.create')); ?>" class="btn btn-primary"> <i class="fa fa-plus me-2"
                            aria-hidden="true"></i>+ Add New Testimonial</a>
                </div>

                <div class="row g-3 clearfix row-deck mb-3">
                    <div class="col-lg-12 col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <form class="row g-3" id="filter_form">
                                    <div class="row">
                                        <div class="col-md-2 mt-3">
                                            <label class="form-label">Name</label>
                                            <input type="text" class="form-control" name="name" id="name" placeholder=" Name">
                                        </div>
                                        
                                        <div class="col-md-3" style="padding-top:2.5rem;">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn bg-primary btn-xs text-white"
                                                id="filterBtn"><i class="ri-search-line search-icon"></i></button>
                                            <button type="button" class="btn bg-danger btn-xs text-white "
                                                id="resetfilterBtn">X</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1">Testimonials </h5>
                                <!-- <div>
                                    <button type="button" class="downloads btn btn-success">Download</button>
                                </div> -->
                            </div>
                            <div class="card-body">
                                <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                                    <thead>
                                        <tr>                                          
                                            <th>Sl No:</th>
                                            <th>Name</th>
                                            <th>Image</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('click', '.delete-button', function() {
            var thisel = $(this).val();
            let id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((data) => {
                if (data.isConfirmed) {
                    Swal.fire(
                        'Deleted!',
                        'Your file has been deleted.',
                        'success'
                    );
                    $.ajax({
                        url: "<?php echo e(url('testimonials')); ?>/" + thisel,
                        type: 'DELETE',
                        data: {
                            '_token': "<?php echo e(csrf_token()); ?>"
                        },
                        success: function(data) {
                            toastr.success('Your file has been deleted.', 'Deleted!');
                            location.reload();
                        },
                        error: function(xhr, status, error) {
                            console.error(xhr.responseText);
                        }
                    });
                }
            });
        });

        var tableX = $('#scroll-horizontal').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo e(url('testimonial-filter')); ?>",
                data: function(d) {
                    d.name = $('#name').val();
                }
            },
            "columns": [{
                    
                
                    data: 'DT_RowIndex',
                    orderable: false,
                    searchable: false,
                },
                {
                    data: "name",
                    name: "name"
                },
                {
                    data: "image",
                    name: "image"
                },
                {
                    data: "action",
                    name: "action"
                }
            ],
            responsive: true,
            "searching": false,
            "bStateSave": true,
            "bAutoWidth": false,
            "ordering": false,
        });
        $('#filterBtn').on('click', function() {
            tableX.draw();
        });
        $('#resetfilterBtn').on('click', function() {
            $('#product_name').val('');
            $('#title').val('');
            tableX.draw();
        });

      
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xa\htdocs\petrol_products\resources\views/admin/testimonial/index.blade.php ENDPATH**/ ?>