
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Product</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="<?php echo e(url('product')); ?>">Product</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="<?php echo e(route('product.update', $data->id)); ?>" method="post"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row gy-4">
                                        <div class="col-xxl-4 col-md-4">
                                            <div>
                                                <label>Select Category</label>
                                                <select name="category" class="form-select">
                                                    <option value="">Choose</option>
                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($category->id); ?>" <?php if($data->category_id == $category->id ): ?> selected <?php endif; ?>><?php echo e($category->category_name); ?></option>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xxl-4 col-md-4">
                                            <div>
                                                <label>Product Name</label>
                                                <input type="text" value="<?php echo e($data->product_name); ?>" class="form-control"
                                                    name="product_name" id="product_name_id" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-xxl-4 col-md-4">
                                            <label>Image</label>
                                            <input type="file" value="<?php echo e($data->image); ?>" class="form-control"
                                                name="image" id="image_id" placeholder="Image">
                                            
                                        </div>
                                        <div class="col-xxl-1 col-md-1">
                                            <img src="<?php echo e(asset('public/image')); ?>/<?php echo e($data->image); ?>" width="25px;"
                                                height="25px;" style="width:30px;height:30px;margin-bottom: -70px;">
                                            </div>
                                        <div class="col-xxl-12 col-md-12">
                                            <div>
                                                <label>Description</label>
                                                <textarea class="form-control summernote" name="description" 
                                                        id="description" placeholder="Enter Project Name" ><?php echo e($data->description); ?></textarea>
                                            </div>
                                        </div>
                                        
                                    </div>
                                    <div class="col-md-12 mb-3 text-end mt-5">
                                        <button type="submit" class="btn  btn-success ">Submit</button>
                                        <a class="btn  btn-secondary" href="<?php echo e(url('product')); ?>">Back</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        var gArrayFonts=['Noto Sans'];
        $('.summernote').summernote({
                height:200,
            fontNames: gArrayFonts,
              fontNamesIgnoreCheck: gArrayFonts,
              fontSizes: ['8', '9', '10', '11', '12', '13', '14', '15', '16', '18', '20', '22' , '24', '28', '32', '36', '40', '48'],
            followingToolbar: false,
              dialogsInBody: true,
            
            toolbar: [
            // [groupName, [list of button]]
            ['style'],
            ['style', ['clear', 'bold', 'italic', 'underline']],
            ['fontname', ['fontname']],
            ['fontsize', ['fontsize']],
            ['color', ['color']],       
            ['para', ['ul', 'ol', 'paragraph']],
            ['insert', ['picture','link','table']],
             
            ['view', ['codeview','fullscreen']]
            ]
        });
    });

    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminlayouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xa\htdocs\petrol_products\resources\views/admin/product/edit.blade.php ENDPATH**/ ?>