<?php

use Illuminate\Support\Facades\Route;

Route::get('login', function () {
    return view('auth.login');
});
Route::get('/', [App\Http\Controllers\FrontendController::class, 'index']);
Route::get('products', [App\Http\Controllers\FrontendController::class, 'products']);
Route::get('products/{slug}', [App\Http\Controllers\FrontendController::class, 'productsDetails']);
Route::get('about-us', [App\Http\Controllers\FrontendController::class, 'aboutUs']);
Route::get('our-clients', [App\Http\Controllers\FrontendController::class, 'clients']);
Route::get('contact', [App\Http\Controllers\FrontendController::class, 'contact']);
Route::get('careers', [App\Http\Controllers\FrontendController::class, 'career']);
Route::post('store-contact-form', [App\Http\Controllers\FrontendController::class, 'storeContactForm']);
Route::post('store-enquiry-form', [App\Http\Controllers\FrontendController::class, 'storeEnquiryForm']);
Route::post('store-career-form', [App\Http\Controllers\FrontendController::class, 'storeCareerForm']);

Auth::routes();
Route::group(['middleware' => 'auth'], function () {
    Route::get('/logout', 'App\Http\Controllers\Auth\LoginController@logout');
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/dashboard',[App\Http\Controllers\HomeController::class, 'dashboard'])->name('dashboard'); 
    
    //product
    Route::resource('product', 'App\Http\Controllers\ProductController');
    Route::get('product-filter', 'App\Http\Controllers\ProductController@filter');

    //settings
    Route::resource('settings', 'App\Http\Controllers\SettingsController');
    Route::get('settings-filter', 'App\Http\Controllers\SettingsController@filter');

    //contact us
    Route::resource('contact-us', 'App\Http\Controllers\ContactUsController');
    Route::get('contact-filter', 'App\Http\Controllers\ContactUsController@filter');

    //gallery
    Route::resource('gallery', 'App\Http\Controllers\GalleryController');
    Route::get('gallery-filter', 'App\Http\Controllers\GalleryController@filter');
    Route::get('get-images', 'App\Http\Controllers\GalleryController@getImages');
    Route::delete('delete-img/{id}','App\Http\Controllers\GalleryController@deleteImage')->name('img.delete');

    //banner
    Route::resource('banner', 'App\Http\Controllers\BannerController');
    Route::get('banner-filter', 'App\Http\Controllers\BannerController@filter');

    //Category
    Route::resource('category', 'App\Http\Controllers\CategoryController');
    Route::get('category-filter', 'App\Http\Controllers\CategoryController@filter');
    Route::post('fetch-category', ['as' => 'fetch-category', 'uses' => 'App\Http\Controllers\CategoryController@fetchCategory']);

    //Clients
    Route::resource('clients', 'App\Http\Controllers\ClientController');
    Route::get('client-filter', 'App\Http\Controllers\ClientController@filter');

    //Enquiry
    Route::resource('enquiry', 'App\Http\Controllers\EnquiryController');
    Route::get('enquiry-filter', 'App\Http\Controllers\EnquiryController@filter');

    //Enquiry
    Route::resource('testimonials', 'App\Http\Controllers\TestimonialController');
    Route::get('testimonial-filter', 'App\Http\Controllers\TestimonialController@filter');
    
    Route::resource('career', 'App\Http\Controllers\CareerController');
    Route::get('career-filter', 'App\Http\Controllers\CareerController@filter');
    Route::get('career/{id}/view-applications', 'App\Http\Controllers\CareerController@viewApplications');
    Route::get('career-application-filter',  'App\Http\Controllers\CareerController@applicationsfilter');
    Route::get('career/{id}/download', 'App\Http\Controllers\CareerController@applicationsdownload');


});
