@extends('layouts.frontlayouts')
@section('content')
 <!-- breadcrumb-area-start -->
 <div class="breadcrumb-area pt-245 pb-255" style="height:80px;padding-top:118px;padding-bottom:213px;background-image:url({{asset('public/image/banner_3.png')}})">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="breadcrumb-text text-center">
                    <h1>Our Products</h1>
                    <ul class="breadcrumb-menu">
                        <li><a href="{{url('/')}}">home</a></li>
                        <li><span>Products</span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumb-area-end -->

<!-- services-area start  -->
<div class="services-area pt-130 pb-130">
    <div class="container">
        <div class="row ">
            @foreach($products as $product)
            <a href="{{url('products/'.$product->slug)}}"><div class="col-xl-4 col-lg-4 col-md-6">
                <div class="b-services b-services-02 mb-80">
                    <div class="b-services-img"style="text-align:center;">
                        @if($product->image != '')
                        <img src="{{asset('public/images/product/'.$product->image)}}" alt="" style="width:100%;">
                        @else
                       
                        @endif
                    </div>
                    <div class="b-services-content">
                        <h3><a href="{{url('products/'.$product->slug)}}">{{$product->product_name}}</a></h3>
                        <p>{!! \Illuminate\Support\Str::words(strip_tags($product->short_description), 20, '...') !!}</p>
                        <div class="sv-link">
                            <a href="{{url('products/'.$product->slug)}}">read more</a>
                        </div>
                    </div>
                </div>
            </div></a>
            @endforeach
        </div>
        {{-- <div class="row">
            <div class="col-xl-12">
                <div class="fea-btn text-center">
                    <a class="b-btn btn-black" href="#">
                        <span>view all Products</span>
                    </a>
                </div>
            </div>
        </div> --}}
    </div>
</div>
<!-- services-area start  -->

<!-- brand-area-start -->
<!--<div class="brand-area pb-130 pt-100">-->
<!--    <div class="container">-->
<!--        <div class="row brand-active">-->
<!--            @foreach($clients as $client)-->
<!--            <div class="col-xl-12">-->
<!--                <div class="brand-img text-center">-->
<!--                    <img src="{{asset('public/images/client/'.$client->logo)}}" alt="" />-->
<!--                </div>-->
<!--            </div>-->
<!--            @endforeach-->
<!--        </div>-->
<!--    </div>-->
<!--</div>-->
<!-- brand-area-end -->

@endsection