@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Edit</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('testimonials') }}">Testimonials</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{ route('testimonials.update', $data->id) }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="row gy-4">
                                        
                                        <div class="col-xxl-6 col-md-6">
                                            <div>
                                                <label> Name</label>
                                                <input type="text" value="{{ $data->name }}" class="form-control"
                                                    name="name" id="name" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-xxl-4 col-md-4">
                                            <label>Image</label>
                                            <input type="file" value="{{ $data->image }}" class="form-control"
                                                name="image" id="image_id" placeholder="Image">
                                            
                                        </div>
                                        <div class="col-xxl-2 col-md-2">
                                            <img src="{{ asset('public/images/testimonial') }}/{{ $data->image }}" width="25px;"
                                                height="25px;" style="width:30px;height:30px;margin-bottom: -70px;">
                                            </div>
                                        <div class="col-xxl-12 col-md-12">
                                            <div>
                                                <label>Description</label>
                                                <textarea class="form-control " name="description" 
                                                        id="description" placeholder="Enter Description" >{{$data->description}}</textarea>
                                            </div>
                                        </div>
                                        
                                    </div>
                                    <div class="col-md-12 mb-3 text-end mt-5">
                                        <button type="submit" class="btn  btn-success ">Submit</button>
                                        <a class="btn  btn-secondary" href="{{ url('testimonials') }}">Back</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

