@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Edit</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('staff') }}">Staff</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{ route('staff.update', $data->id) }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="row gy-4">
                                        <div class="col-xxl-6 col-md-3">
                                            <div>
                                                <label>Name</label>
                                                <input type="text" value="{{ $data->name }}" class="form-control"
                                                    name="name" id="name_id" required>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div>
                                                <label>Email</label>
                                                <input type="text" value="{{ $data->email }}" class="form-control"
                                                    name="email" id="email">
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div>
                                                <label>Contact No:</label>
                                                <input type="text" value="{{ $data->contact_no }}" class="form-control"
                                                    name="contact_no" id="contact_no_id" required>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div>
                                                <label>Date Of Joining</label>
                                                <input type="text" value="{{ $data->date_of_joining }}" class="form-control"
                                                    name="date_of_joining" id="date_of_joining" required>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div>
                                                <label>Password</label>
                                                <input type="text"
                                                    class="form-control" name="password"
                                                    id="password" placeholder="Enter Password"
                                                    required>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div>
                                                <label>Address</label>
                                                <textarea class="form-control" name="address" id="address_id" rows="3" required>{{ $data->address }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3 text-end mt-5">
                                        <button type="submit" class="btn  btn-success ">Submit</button>
                                        <a class="btn  btn-secondary" href="{{ url('staff') }}">Back</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
