@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Create</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('staff') }}">Staff</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{ route('staff.store') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-3">
                                                <div>
                                                    <label>Name</label>
                                                    <input type="text" class="form-control" name="name" id="name_id"
                                                        placeholder="Enter Name" required>
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label>Email</label>
                                                    <input type="text" class="form-control" name="email"
                                                        id="email" placeholder="Enter Email ID">
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label>Date Of Joining</label>
                                                    <input type="date" class="form-control" name="date_of_joining"
                                                        id="date_of_joining">
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label>Contact No:</label>
                                                    <input type="text" class="form-control" name="contact_no"
                                                        id="contact_no_id" placeholder="Enter Contact No:" required>
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label>Password</label>
                                                    <input type="text" class="form-control" name="password"
                                                        id="password" placeholder="Enter password"
                                                        required>
                                                </div>
                                            </div>
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label>Address</label>
                                                    <textarea class="form-control" name="address" id="address_id" rows="3" placeholder="Enter Address" required></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3 text-end mt-5">
                                        <button type="submit" class="btn  btn-success ">Submit</button>
                                        <a class="btn  btn-secondary" href="{{ url('staff') }}">Back</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection()
