@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Settings</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('settings') }}">Settings</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row g-3 clearfix row-deck mb-3">
                    <div class="col-lg-12 col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <form class="row g-3" id="filter_form">
                                    <div class="row">
                                        <div class="col-md-3 mt-3">
                                            <label class="form-label"> Label</label>
                                            <input type="text" class="form-control" name="label" id="label" placeholder="Label">
                                        </div>
                                        <div class="col-md-3 mt-3">
                                            <label class="form-label"> Value</label>
                                            <input type="text" class="form-control" name="value" id="value" placeholder="Value">
                                        </div>
                                        <div class="col-md-4" style="padding-top:2.5rem;">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn bg-primary btn-xs text-white"
                                                id="filterBtn"><i class="ri-search-line search-icon"></i></button>
                                            <button type="button" class="btn bg-danger btn-xs text-white "
                                                id="resetfilterBtn">X</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1">Settings </h5>
                            </div>
                            <div class="card-body">
                                <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>Sl No:</th>
                                            <th>Label</th>                                          
                                            <th>Value</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
               
            </div>
        </div>
    </div>
@endsection()

@section('scripts')
<script type="text/javascript">
    $(document).on('click', '.delete-button', function() {
            var thisel = $(this).val();
            let id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((data) => {
                if (data.isConfirmed) {
                    Swal.fire(
                        'Deleted!',
                        'Your file has been deleted.',
                        'success'
                    )
                    $.ajax({
                        url: "{{ url('settings') }}/" + thisel,
                        type: 'DELETE',
                        data: {
                            '_token': "{{ csrf_token() }}"
                        },
                        success: function(data) {
                            location.reload();
                        }
                    });
                }
            });
        });

        var tableX = $('#scroll-horizontal').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ url('settings-filter') }}",
                data: function(d) {
                    d.label = $('#label').val();
                    d.value = $('#value').val();
                }
            },
            "columns": [{
                    data: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: "label",
                    name: "label"
                },                
                {
                    data: "value",
                    name: "value"
                },
                {
                    data: "action",
                    name: "action"
                }
            ],
            responsive: true,
            "searching": false,
            "bStateSave": true,
            "bAutoWidth": false,
            "ordering": false,
        });
        $('#filterBtn').on('click', function() {
            tableX.draw();
        });
        $('#resetfilterBtn').on('click', function() {
            $('#label').val('');
            $('#value').val('');
            tableX.draw();
        });
</script>
@endsection