@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Product</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                                    <!-- <li class="breadcrumb-item"><a href="{{ url('product') }}">Product</a></li> -->
                                    <li class="breadcrumb-item active">Product</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col text-lg-end mb-3">
                    <a href="{{ route('product.create') }}" class="btn btn-primary"> <i class="fa fa-plus me-2"
                            aria-hidden="true"></i>+ Add New Product</a>
                </div>

                <div class="row g-3 clearfix row-deck mb-3">
                    <div class="col-lg-12 col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <form class="row g-3" id="filter_form">
                                    <div class="row">
                                        <div class="col-md-2 mt-3">
                                            <label class="form-label">Product Name</label>
                                            <input type="text" class="form-control" name="product_name" id="product_name" placeholder="Product Name">
                                        </div>
                                        {{-- <div class="col-md-3 mt-3">
                                            <label class="form-label">Title</label>
                                            <input type="text" class="form-control" name="title" id="title" placeholder="Title">
                                        </div> --}}
                                        <div class="col-md-3" style="padding-top:2.5rem;">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn bg-primary btn-xs text-white"
                                                id="filterBtn"><i class="ri-search-line search-icon"></i></button>
                                            <button type="button" class="btn bg-danger btn-xs text-white "
                                                id="resetfilterBtn">X</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1">Product </h5>
                                <!-- <div>
                                    <button type="button" class="downloads btn btn-success">Download</button>
                                </div> -->
                            </div>
                            <div class="card-body">
                                <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                                    <thead>
                                        <tr>                                          
                                            <th>Sl No:</th>
                                            <th>Product Name</th>
                                            <th>Category</th>
                                            <th>Image</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
@endsection()

@section('scripts')
    <script>
        $(document).on('click', '.delete-button', function() {
            var thisel = $(this).val();
            let id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((data) => {
                if (data.isConfirmed) {
                    Swal.fire(
                        'Deleted!',
                        'Your file has been deleted.',
                        'success'
                    );
                    $.ajax({
                        url: "{{ url('product') }}/" + thisel,
                        type: 'DELETE',
                        data: {
                            '_token': "{{ csrf_token() }}"
                        },
                        success: function(data) {
                            toastr.success('Your file has been deleted.', 'Deleted!');
                            location.reload();
                        },
                        error: function(xhr, status, error) {
                            console.error(xhr.responseText);
                        }
                    });
                }
            });
        });

        var tableX = $('#scroll-horizontal').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ url('product-filter') }}",
                data: function(d) {
                    d.product_name = $('#product_name').val();
                    d.title = $('#title').val();
                }
            },
            "columns": [{
                    
                
                    data: 'DT_RowIndex',
                    orderable: false,
                    searchable: false,
                },
                {
                    data: "product_name",
                    name: "product_name"
                },

                {
                    data: "category",
                    name: "category"
                },
                {
                    data: "image",
                    name: "image"
                },
                {
                    data: "action",
                    name: "action"
                }
            ],
            responsive: true,
            "searching": false,
            "bStateSave": true,
            "bAutoWidth": false,
            "ordering": false,
        });
        $('#filterBtn').on('click', function() {
            tableX.draw();
        });
        $('#resetfilterBtn').on('click', function() {
            $('#product_name').val('');
            $('#title').val('');
            tableX.draw();
        });

        $(document).on('click', '.open-modal', function() {
            $('#addStockModel').find('input[name=id]').val($(this).val());
            $('#addStockModel').modal('show');
        });
        $(document).on('click', '.add-stock', function() {
            var fd = $('#addStockModelform').serialize() + "&_token={{ csrf_token() }}";
            $.ajax({
                url: "{{ url('add-stock') }}",
                type: "POST",
                data: fd,
                success: function(response) {
                    if (response == 1) {
                        let timerInterval
                        Swal.fire({
                            title: 'Successfully Added',
                            timer: 2000,
                            timerProgressBar: true,
                            didOpen: () => {
                                Swal.showLoading()
                                timerInterval = setInterval(() => {
                                    const content = Swal.getContent()
                                    if (content) {
                                        const b = content.querySelector('b')
                                        if (b) {
                                            b.textContent = Swal.getTimerLeft()
                                        }
                                    }
                                }, 100)
                            },
                            willClose: () => {
                                clearInterval(timerInterval)
                            }
                        }).then((result) => {
                            if (result.dismiss === Swal.DismissReason.timer) {
                                console.log('I was closed by the timer')
                            }
                        })
                        $('#addStockModel').modal('hide');
                    }
                }
            });
        });
    </script>
@endsection
