@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Gallery</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('gallery') }}">Gallery</a></li>
                                    <li class="breadcrumb-item active">View</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1">Image Details </h5>
                                <div class="col text-lg-end">
                                    <a href="{{ url('project') }}"> </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <br><label class="col-md-6"style="float:left">Title</label>
                                    <h6 class="col-md-6"><strong>{{ ucfirst($data->title) }}</strong></h6><br>
                                </div> 
                
                                <!-- <div class="card-header d-flex align-items-center">
                                    <h5 class="card-title mb-0 flex-grow-1">Images</h5>
                                </div> -->
                                <table class="table w-100 mt-20" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>Sl No</th>
                                            <th>Images</th>
                                        </tr>
                                        @php
                                            $a = 0;
                                        @endphp
                                    <tbody>
                                        @foreach ($imgs as $img)
                                            <tr>
                                                @php
                                                    $a++;                                                                                           
                                                @endphp
                                                <th>{{ $a }}</th>
                                                <td><img src="{{ asset('public/image') }}/{{ $img->image }}" height="50px;"></td>                                              
                                            </tr>                             
                                        @endforeach
                                    </tbody>
                                    </thead>
                                </table>
                                <div class="card-footer">
                                    <a href="{{ url('gallery') }}" class="btn btn-primary" style="float:right">Back</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
