@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Edit</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('gallery') }}">Gallery</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{ route('gallery.update', $data->id) }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="row gy-4">
                                        <div class="col-xxl-6 col-md-6">
                                            <div>
                                                <label>Title</label>
                                                <input type="text" value="{{ $data->title }}" class="form-control"
                                                    name="title" id="title" required>
                                            </div>
                                        </div>
                                    <!-- </div> -->
                                        <div class="row gy-4">  
                                                <div class="col-6">
                                                    Add Images
                                                </div>
                                                <div class="col-6" style="align-content: flex-end; padding-left: 110px;">
                                                    <button class="btn btn-primary" type="button" id="addImage">+</button>
                                                </div>
                                            </div>
                                            <!-- </div> -->
                                            <div id="appendImages"></div>
                                                <input type="hidden" name="hiddenVal" id="hiddenVal">
                                            @foreach($item as $key=>$img)
                                            <div class="row">
                                                <input type="hidden" name="imageid[]" value="{{$img->id}}">
                                                <div class="col-xxl-6 col-md-6">
                                                    <label>Image</label>
                                                    <input type="file" name="image_edit[]" class="form-control">
                                                    
                                                </div>
                                                <div class="col-xxl-1 col-md-1">
                                                    @if ($img->image!='') 
                                                        <img src="{{ asset('public/image') }}/{{ $img->image }}" style="width:30px;height:30px;margin-bottom: -70px;">
                                                    @endif
                                                </div>
                                                <div class="col-md-4 mb-1 mt-4">
                                                    <button type="button" class="btn btn-danger delete-row" data-row-id="{{ $img->id }}"><i class="ri-delete-bin-5-fill fs-16 text-white"></i></button>
                                                </div>
                                            </div>
                                            @endforeach
                                    </div>
                                    <div class="col-md-12 mb-3 text-end mt-5">
                                        <button type="submit" class="btn  btn-success ">Submit</button>
                                        <a class="btn  btn-secondary" href="{{ url('gallery') }}">Back</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script type="text/javascript">
    $('#addImage').click(function(){
            $.ajax({
                url:"{{url('get-images')}}",
                type:'get',
                success:function(response){
                    $('#appendImages').append(response);
                }
            });
            counter ++;
        });

        $(document).on('click','#removeImage',function(){
            $(this).closest('.row').remove();
        });

        $(document).on('click','.delete-row',function(){
            var rowId = $(this).data('row-id');
            var url = "{{ route('img.delete', ':id') }}";
                url = url.replace(':id', rowId);
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((data) => {
                    if (data.isConfirmed) {
                        Swal.fire(
                            'Deleted!',
                            'Your file has been deleted.',
                            'success'
                        );
                        $.ajax({
                            url: url,
                            type: 'DELETE',
                            data: {
                                "_token": "{{ csrf_token() }}"
                            },
                            success: function(response) {
                                $('tr[data-row-id="' + rowId + '"]').remove();
                                toastr.success('Your file has been deleted.', 'Deleted!', {
                                    timeOut: 5000,
                                });    
                            },
                            error: function(xhr) {
                            }
                        });
                    }
                });
        });
</script>
@endsection