@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Create</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('gallery') }}">Gallery</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{ route('gallery.store') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label>Title</label>
                                                    <input type="text" class="form-control" name="title"
                                                        id="title"  placeholder="Enter Title">
                                                </div>
                                            </div>  
                                            <div class="row gy-4">  
                                                <div class="col-6">
                                                    Add Images
                                                </div>
                                                <div class="col-6" style="align-content: flex-end">
                                                    <button class="btn btn-primary" type="button" id="addImage">+</button>
                                                </div>
                                            </div>
                                            <div id="appendImages"></div>
                                                <input type="hidden" name="hiddenVal" id="hiddenVal">
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3 text-end mt-5">
                                        <button type="submit" class="btn btn-success ">Submit</button>
                                        <a class="btn  btn-secondary" href="{{ url('gallery') }}">Back</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection()

@section('scripts')
<script type="text/javascript">
    $('#addImage').click(function(){
            $.ajax({
                url:"{{url('get-images')}}",
                type:'get',
                success:function(response){
                    $('#appendImages').append(response);
                }
            });
            counter ++;
        });

        $(document).on('click','#removeImage',function(){
            $(this).closest('.row').remove();
        });
</script>
@endsection