@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">View</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('clients') }}">Clients</a></li>
                                    <li class="breadcrumb-item active">View</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1">Client Details </h5>
                                <div class="col text-lg-end">
                                    <a href="{{ url('clients') }}"> </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <label class="col-md-6"style="float:left">Client Name</label>
                                    <h6 class="col-md-6">{{ ucfirst($data->client_name) }}</h6><br>
                                </div>
                                
                                <div class="row">
                                    <label class="col-md-6"style="float:left">Client Phone </label>
                                    <h6 class="col-md-6">{{ ucfirst($data->client_phone) }}</h6><br>
                                </div>
                                <div class="row">
                                    <br><label class="col-md-6"style="float:left">Client Email</label>
                                    <h6 class="col-md-6">{{ ucfirst($data->client_email) }}</h6><br>
                                </div>
                                <div class="row">
                                    <br><label class="col-md-6"style="float:left">Client Address</label>
                                    <h6 class="col-md-6">{{ ucfirst($data->client_address) }}</h6><br>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="card-text">Logo</h6><br>
                                    </div>
                                    <div class="col-md-6">
                                        @if ($data->logo)
                                            <img src="{{ asset('public/images/client/'.$data->logo) }}" height="100px;">
                                        @else
                                            <p>Logo is not Available</p>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <a href="{{ url('clients') }}" class="btn btn-primary" style="float:right">Back</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
