@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Edit</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('clients') }}">Clients</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{ route('clients.update', $data->id) }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-4 col-md-4">
                                                <div>
                                                    <label>Client Name</label>
                                                    <input type="text" class="form-control" name="client_name"
                                                        id="client_name" placeholder="Client Name" value="{{$data->client_name}}" required>
                                                </div>
                                            </div> 
                                            <div class="col-xxl-4 col-md-4">
                                                <div>
                                                    <label>Client Phone</label>
                                                    <input type="text" class="form-control" name="client_phone"
                                                        id="client_phone" value="{{$data->client_phone}}" required>
                                                </div>
                                            </div> 
                                            <div class="col-xxl-4 col-md-4">
                                                <div>
                                                    <label>Client Email</label>
                                                    <input type="text" class="form-control" name="client_email"
                                                        id="client_email" value="{{$data->client_email}}" >
                                                </div>
                                            </div> 
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label>Address</label>
                                                    <textarea class="form-control " name="client_address"
                                                        id="client_address" placeholder="Address" >{{$data->client_address}}</textarea>
                                                </div>
                                            </div> 
                                            <div class="col-xxl-6 col-md-6">
                                                <div>
                                                    <label>Logo</label>
                                                    <input type="file" class="form-control" name="logo"
                                                        id="logo"  required>
                                                </div>
                                            </div> 
                                                                                  
                                            
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3 text-end mt-5">
                                        <button type="submit" class="btn btn-success ">Submit</button>
                                        <a class="btn  btn-secondary" href="{{ url('clients') }}">Back</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection()