@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Category</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('category') }}">Category</a></li>
                                    <li class="breadcrumb-item active">View</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1">Category Details </h5>
                                <div class="col text-lg-end">
                                    <a href="{{ url('category') }}"> </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <label class="col-md-6"style="float:left">Category Name</label>
                                    <h6 class="col-md-6">{{ ucfirst($data->category_name) }}</h6><br>
                                </div>
                                <div class="row">
                                    <label class="col-md-6"style="float:left">Is Parent </label>
                                    <h6 class="col-md-6">{{ ucfirst($data->is_parent) }}</h6><br>
                                </div>
                                <div class="row">
                                    <label class="col-md-6"style="float:left">Position </label>
                                    <h6 class="col-md-6">{{ ucfirst($data->position) }}</h6><br>
                                </div>
                                <div class="row">
                                    <br><label class="col-md-6"style="float:left">Description</label>
                                    <h6 class="col-md-6">{!! $data->description !!}</h6><br>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="card-text">Icon</h6><br>
                                    </div>
                                    <div class="col-md-6">
                                        @if ($data->icon)
                                            <img src="{{ asset('public/images/category/'.$data->icon) }}" height="100px;">
                                        @else
                                            <p>Icon is not Available</p>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <a href="{{ url('category') }}" class="btn btn-primary" style="float:right">Back</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
