@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Edit</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('category') }}">Category</a></li>
                                    <li class="breadcrumb-item active">Edit</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <form action="{{ route('category.update', $data->id) }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label" for="product-title-input">Category Name</label>
                                            <input type="text" class="form-control" id="product-title-input"
                                                value="{{ $data->category_name }}" name="category_name"
                                                placeholder="Enter Category Name" required>
                                                <input type="hidden" value="{{$data->id}}" name="id">
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label" for="product-title-input">Position</label>
                                            <input type="number" class="form-control" id="product-title-input"
                                                name="position" value="{{ $data->position }}" required>

                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label" for="product-title-input">Upload New Category
                                                Icon(optional)</label>
                                            <input type="file" class="form-control" id="product-title-input"
                                                value="" name="category_icon" >

                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label" for="product-title-input">Is Parent Category</label>

                                            <select class="form-select is_parent" id="choices-publish-visibility-input "
                                                name="is_parent" data-choices data-choices-search-false>
                                                <option value="yes" selected
                                                    {{ $data->is_parent == 'yes' ? 'selected' : '' }}>Yes
                                                </option>
                                                <option value="no" {{ $data->is_parent == 'no' ? 'selected' : '' }}>No
                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3" id="subcategory">
                                            @if ($data->is_parent == 'no')
                                                <label class="form-label" for="product-title-input">Parent Category</label>

                                                <select class="form-select" id="choices-publish-visibility-input"
                                                    name="parentcategory" data-choices data-choices-search-false>
                                                    <option value="">Choose parent Category</option>
                                                    @foreach ($categorylist as $list)
                                                        <option value="{{ $list->id }}"
                                                            {{ $list->id == $data->parent_category_id ? 'selected' : '' }}>
                                                            {{ $list->category_name }}</option>
                                                    @endforeach()
                                                </select>
                                            @endif
                                        </div>

                                        
                                        <div class="mb-5">
                                            <label for="courseDescription" class="form-label">Description</label>
                                            <textarea class="form-control" id="description" name="description" required>{{ $data->description }}
                                    </textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-end mb-3">
                                    <a href="{{ url('category') }}" class="btn btn-primary" style="width:95px;">Back</a>
                                    <button type="submit" class="btn btn-success w-sm">Submit</button>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection()

@section('scripts')
    <script type="text/javascript">
        $(document).on('change', '.is_parent', function() {
            var id = $(".is_parent").val();
            if (id == 'no') {
                $.ajax({
                    type: "POST",
                    url: "{{ route('fetch-category') }}",
                    data: {
                        '_token': '{{ csrf_token() }}'
                    },
                    success: function(data) {
                        $('#subcategory').html(data);
                    }
                });
            } else {
                $('#subcategory').html('');
            }
        });
    </script>
@endsection
