@extends('layouts.adminlayouts')
@section('content')
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">EDIT</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="{{ url('career') }}">Career</a></li>
                                <li class="breadcrumb-item active">Edit</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="{{ route('career.update', $data->id) }}" method="post"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row gy-4">
                                    <div class="col-xxl-6 col-md-3">
                                        <div>
                                            <label> Role</label>
                                            <input type="text" value="{{ $data->role }}" class="form-control"
                                                name="role" id="role" required>
                                        </div>
                                    </div>


                                    <div class="col-xxl-6 col-md-3">
                                        <div>
                                            <label> Experience</label>
                                            <input type="text" value="{{ $data->experience }}" class="form-control"
                                                name="experience" id="experience" required>
                                        </div>
                                    </div>




                                    <div class="col-xxl-12 col-md-12">
                                        <div>
                                            <label>Description</label>
                                            <textarea class="form-control" name="description" id="description"
                                                placeholder="Enter Description">{{$data->description}}</textarea>
                                        </div>
                                    </div>

                                   


                                </div>
                        </div>
                        <div class="col-md-12 mb-3 text-end mt-5">
                            <button type="submit" class="btn  btn-success ">Submit</button>
                            <a class="btn  btn-secondary" href="{{ url('career') }}">Back</a>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
@endsection