@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Create</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('blog') }}">Blogs</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <form action="{{ route('blog.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label" for="product-title-input">Title</label>
                                            <input type="text" class="form-control" name="title" id="title" placeholder="Title"required>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label" for="product-title-input">Author</label>
                                            <input type="text" class="form-control" name="author" id="author" placeholder="Author"required>

                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label" for="product-title-input">Is Published</label>
                                            <select class="form-control" name="is_published" required>
                                                <option value="" selected disabled>Choose</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                            </select>

                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label" for="product-title-input">Created Date</label>
                                            <input type="date" class="form-control" name="created_date" id="created_date" placeholder="Date"required>
                                        </div>
                                        <div class="col-md-12 mb-5">
                                            <label for="courseDescription" class="form-label">Short Description</label>
                                            <textarea   class="form-control" name="short_description" >{{ old('short_description') }}</textarea>
                                    
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Meta Title</label>
                                            <input type="text" class="form-control" name="meta_title" value="{{ old('meta_title') }}">
                                            </div>
                                            
                                            <div class=" col-md-12 mb-3">
                                            <label class="form-label">Meta Keyword</label>
                                            <input type="text" class="form-control" name="meta_keyword" value="{{ old('meta_keyword') }}">
                                            </div>
                                            
                                            <div class=" col-md-12 mb-3">
                                            <label class="form-label">Meta Description</label>
                                            <input type="text" class="form-control" name="meta_description" value="{{ old('meta_description') }}">
                                            </div>
                                            <div class="form-group col-md-6 mb-3">
                                                <label>Thumbnail Image (  868px * 514px )</label>
                                                <input type="file" class="form-control" name="thumbnail" id="thumbnail" required>
                                            </div>
                                            <div class="col-md-12 mb-3">
                                              <label class="form-label">Content</label>
                                              <textarea id="summernote"  class="form-control summernote" name="content" rows="5"required> </textarea>
                                            </div>
                                    </div>
                                </div>
                                <div class="text-end mb-3">
                                    <a href="{{ url('blog') }}" class="btn btn-primary" style="width:95px;">Back</a>
                                    <button type="submit" class="btn btn-success w-sm">Submit</button>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection()

@section('scripts')
<script src="{{ asset('assets/admin/js/bundle/summernote.bundle.js') }}"></script>
    <script type="text/javascript">
       $(document).ready(function() {
      var gArrayFonts=['Noto Sans'];
	$('.summernote').summernote({
        height:200,
		fontNames: gArrayFonts,
    	fontNamesIgnoreCheck: gArrayFonts,
    	fontSizes: ['8', '9', '10', '11', '12', '13', '14', '15', '16', '18', '20', '22' , '24', '28', '32', '36', '40', '48'],
		followingToolbar: false,
    	dialogsInBody: true,
		
		toolbar: [
		// [groupName, [list of button]]
		['style'],
		['style', ['clear', 'bold', 'italic', 'underline']],
		['fontname', ['fontname']],
		['fontsize', ['fontsize']],
		['color', ['color']],       
		['para', ['ul', 'ol', 'paragraph']],
		['insert', ['picture','link','table']],
		 
		['view', ['codeview','fullscreen']]
		]
      });
	  $('.summernote').summernote('fontName', 'Noto Sans');
		$('.note-editor .note-btn').on('click', function() {
        $(this).next().toggleClass("show");
      });
    });
    </script>
@endsection
