<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Testimonial;
use DataTables;
use Illuminate\Validation\Rule;
class TestimonialController extends Controller
{
    public function index()
    {
      return view('admin.testimonial.index');
    }
    public function filter(Request $request)
    {
        if($request->ajax()){
          $data = Testimonial::select('testimonial.*');
         
          if($request->has('name') && !empty($request->name))
          {
            $data=$data->where('name','like','%'.$request->name.'%');
          }
         
                   
          $data=$data->get();  
          return Datatables::of($data)

                ->addIndexColumn()
                ->addColumn('image', function($data) { $test='';
                  $test.='<img src="';
                  if($data->image !='')
                  { 
                    $test.=asset('public/images/testimonial').'/'.$data->image;
                    }else{
                      $test.=asset('public/images/img.png');
                    }
                    $test.='" style="width:50px;height:50px;">';
                    return $test;

                   })
                ->addColumn('name', function($data) { return $data->name; })
               
                
                ->rawColumns(['name','image','action'])
                
                ->addColumn('action',function($data){
                  $edit=url('testimonials').'/'.$data->id.'/edit';
                  $view=url('testimonials').'/'.$data->id;
                      return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                      <a href="'.$edit.'" <i class="ri-pencil-fill fs-16 text-primary"></i></a></button>
                      <button type="button" value="'.$data->id.'" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>';  
              })
                ->setRowId(function ($data) {
                     return "row_".$data->id;
               })
                ->make(true);

            
        }
    }
    public function create()
    {
      return view('admin.testimonial.create');
    }
    public function store(Request $request)
    {
      $request->validate([
			'name'=>'required',
			'description'=>'required',
      'image'=>'required'
		]);

		$model= new Testimonial();
		$model->name=$request->input('name');
		$model->description=$request->input('description');	
		$model->created_by=\Auth::user()->id;
		$model->updated_by=\Auth::user()->id;
		$model->created_at=date('Y-m-d H:i:s');
		$model->updated_at=date('Y-m-d H:i:s');

      $path=public_path().'/images/testimonial';

      if($files=$request->file('image'))
      {
          $name=$files->getClientOriginalName();
          $files->move($path,$name);
          $model->image=$name;
      }
		  $model->save();
      return redirect('testimonials');

	    
    }
    public function show($id)
    {
      $data=Testimonial::find($id);
      return view('admin.testimonial.view',[
        'data'=>$data, 
      ]);
      
    }
    public function edit($id)
    {
      $data=Testimonial::find($id);
      return view('admin.testimonial.edit',[
        'data'=>$data
      ]);

    }
    public function update(Request $request,$id)
    {
	    $request->validate([
			'name'=>'required',
			'description'=>'required',
		]);
		$data= Testimonial::find($id);
		$data->name=$request->input('name');
		$data->description=$request->input('description');
		$data->updated_by=\Auth::user()->id;
		$data->updated_at=date('Y-m-d H:i:s');
    $path=public_path().'/images/testimonial';

      if($files=$request->file('image'))
      {
          $name=$files->getClientOriginalName();
          $files->move($path,$name);
          $data->image=$name;
      }
		 $data->save();
     return redirect('testimonials');
       
    }
   
    public function destroy($id)
    {
      $data=Testimonial::find($id)->delete();
      echo 1;
    }

}
?>