<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Settings;
use DataTables;

class SettingsController extends Controller
{
    public function index()
    {
        $data=Settings::get();
        return view('admin.settings.index',[
            'data'=>$data
        ]);
    }

    public function edit($id)
    {
        $data=Settings::find($id);
        return view('admin.settings.edit',[
            'data'=>$data
        ]);
    }

    public function update(Request $request,$id)
    {
        $request->validate([
            'value'=>'required',
             
        ]);
        $data=  Settings::find($id);
        $data->label=$request->label;
        $data->value=$request->value; 
        $data->save();
        return redirect('settings');
    }

    public function destroy($id)
    {
        $data=Settings::find($id);
        $data->delete();
        echo 1;
    }


    public function show($id)
    {
        $data=Settings::find($id);
        return view('admin.settings.view',[
            'data'=>$data
        ]);
    }

    public function filter(Request $request)
    {
        $data=Settings::select('*');
            return Datatables::of($data)
            ->filter(function($data)use($request){
                if($request->has('label') && !empty($request->label)) 
                {
                    $data=$data->where('label','like','%'.$request->label.'%');
                }
                if($request->has('value') && !empty($request->value)) 
                {
                    $data=$data->where('value','like','%'.$request->value.'%');
                }	
                })
                ->addIndexColumn()
                ->addColumn('label',function($data){
                    return ucfirst($data->label);
                })
                ->addColumn('value',function($data){
                    return ucfirst($data->value);
                })
                ->rawColumns(['label','value','action'])
                ->addColumn('action',function($data){
                    $edit=url('settings').'/'.$data->id.'/edit';
                    $view=url('settings').'/'.$data->id;
                        return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                        <a href="'.$edit.'" <i class="ri-pencil-fill fs-16 text-primary"></i></a></button>';  
                })
                ->setRowId(function ($data) {
                    return "row_".$data->id;
                })
                ->make(true);
    }
}
