<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use DataTables;
use Str;
class ProductController extends Controller
{
    public function index()
    {
        $data = Product::get();
        return view('admin.product.index', [
            'data' => $data,
        ]);
    }

    public function create()
    {
        $categories=Category::get();
        return view('admin.product.create',[
            'categories'=>$categories
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'product_name' => 'required',
            'category' => 'required',
        ]);
        $data = new Product();
        $data->product_name = $request->product_name;
        $data->category_id = $request->category;
        $data->slug=Str::slug($request->product_name);
        $data->short_description = $request->short_description;
        $data->position = $request->position;
        $data->description = $request->description;
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $name = $file->getClientOriginalName();
            $path = public_path('images/product');
            $file->move($path, $name);
            $data->image = $name;
        }
        if ($request->hasFile('image1')) {
            $img1file = $request->file('image1');
            $img1name = $img1file->getClientOriginalName();
            $path = public_path('images/product');
            $img1file->move($path, $img1name);
            $data->image1 = $img1name;
        }
        if ($request->hasFile('image2')) {
            $img2file = $request->file('image2');
            $img2name = $img2file->getClientOriginalName();
            $path = public_path('images/product');
            $img2file->move($path, $img2name);
            $data->image2 = $img2name;
        }
        if ($request->hasFile('image3')) {
            $img3file = $request->file('image3');
            $img3name = $img3file->getClientOriginalName();
            $path = public_path('images/product');
            $img3file->move($path, $img3name);
            $data->image3 = $img3name;
        }
        $data->save();
        return redirect('product');
    }

    public function edit($id)
    {
        $data = Product::find($id);
        $categories=Category::get();
        return view('admin.product.edit', [
            'data' => $data,
            'categories' => $categories
        ]);
    }

    public function update(Request $request, $id)
    {
        // dd($request);
        $request->validate([
            'product_name' => 'required',
            'category' => 'required',
        ]);
        $data = Product::find($id);
        $data->product_name = $request->product_name;
        // $data->title = $request->title;
        $data->slug=Str::slug($request->product_name);
        $data->description = $request->description;
        $data->short_description = $request->short_description;
        $data->position = $request->position;
        
        $data->category_id = $request->category;
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $name = str_replace(' ','',$file->getClientOriginalName());
            $path = public_path('images/product');
            $file->move($path, $name);
            $data->image = $name;
        }
        if ($request->hasFile('image1')) {
            $img1file = $request->file('image1');
            $img1name = $img1file->getClientOriginalName();
            $path = public_path('images/product');
            $img1file->move($path, $img1name);
            $data->image1 = $img1name;
        }
        if ($request->hasFile('image2')) {
            $img2file = $request->file('image2');
            $img2name = $img2file->getClientOriginalName();
            $path = public_path('images/product');
            $img2file->move($path, $img2name);
            $data->image2 = $img2name;
        }
        if ($request->hasFile('image3')) {
            $img3file = $request->file('image3');
            $img3name = $img3file->getClientOriginalName();
            $path = public_path('images/product');
            $img3file->move($path, $img3name);
            $data->image3 = $img3name;
        }
        $data->save();
        return redirect('product');
    }

    public function destroy($id)
    {
        $data = Product::find($id);
        $data->delete();
    }

    public function show($id)
    {
        $data = Product::find($id);
        return view('admin.product.view', [
            'data' => $data,
        ]);
    }
    public function filter(Request $request)
    {
        $data = Product::with('category')->select('*');
        return Datatables::of($data)
            ->filter(function ($data) use ($request) {
                if ($request->has('product_name') && !empty($request->product_name)) {
                    $data = $data->where('product_name', 'like', '%' . $request->product_name . '%');
                }
                if ($request->has('title') && !empty($request->title)) {
                    $data = $data->where('title', 'like', '%' . $request->title . '%');
                }
            })
            ->addIndexColumn()
            ->addColumn('product_name', function ($data) {
                return ucfirst($data->product_name);
            })
            ->addColumn('category', function ($data) {
                return ucfirst($data->category->category_name);
            })
            ->addColumn('image', function ($data) {
                if ($data->image != '') {
                    return '<img src="' . asset('public/images/product') . '/' . $data->image . '" style="width:25px; height:25px;">';
                }
            })
            ->rawColumns(['product_name', 'title', 'price', 'image', 'action'])
            ->addColumn('action', function ($data) {
                $edit = url('product') . '/' . $data->id . '/edit';
                $view = url('product') . '/' . $data->id;
                return '<a href="' . $view . '" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                            <a href="' . $edit . '" <i class="ri-pencil-fill fs-16 text-primary"></i></a></button>
                            <button type="button" value="' . $data->id . '" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>';
            })
            ->setRowId(function ($data) {
                return "row_" . $data->id;
            })
            ->make(true);
    }

    
}
