<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Gallery;
use App\Models\GalleryImg;
use DataTables;

class GalleryController extends Controller
{
    public function index()
    {
        $data=Gallery::get();
        return view('admin.gallery.index',[
            'data'=>$data
        ]);
    }

    public function create()
    {
        return view('admin.gallery.create');
    }

    public function store(Request $request)
    {
        $data = new Gallery();
        $data->title=$request->title;
        $data->save();
        if ($request->hasFile('image')) 
        {
            foreach ($request->file('image') as $key => $images) 
            {
                $img= new GalleryImg();
                $img->gallery_id=$data->id;
                $name = $images->getClientOriginalName();
                $path = public_path('/image');
                $images->move($path, $name);
                $img->image = $name;
                $img->save();
            }
        }
        return redirect('gallery');
    }

    public function edit($id)
    {
        $data=Gallery::find($id);
        $item=GalleryImg::where('gallery_id',$id)->get();
        return view('admin.gallery.edit',[
            'data'=>$data,
            'item'=>$item
        ]);
    }

    public function update(Request $request,$id)
    {
        
        $data=  Gallery::find($id);
        $data->title=$request->title;
        $data->save();
        if($request->hasFile('image_edit'))
        {
            foreach($request->file('image_edit')as $key=>$images)
            {
                $img=GalleryImg::find($request->imageid[$key]);
                $name = $images->getClientOriginalName();
                $path = public_path('/image');
                $images->move($path, $name);
                $img->image = $name;
                $img->save();
            }
        }
        if ($request->hasFile('image')) 
        {
            foreach ($request->file('image') as $key => $images) 
            {
                $img= new GalleryImg();
                $img->gallery_id=$data->id;
                $name = $images->getClientOriginalName();
                $path = public_path('/image');
                $images->move($path, $name);
                $img->image = $name;
                $img->save();
            }
        }
        return redirect('gallery');
    }

    public function destroy($id)
    {
        $data=Gallery::find($id);
        $data->delete();
        $imgs=GalleryImg::where('gallery_id',$id)->delete();
    }


    public function show($id)
    {
        $data=Gallery::find($id);
        $imgs=GalleryImg::where('gallery_id',$id)->get();
        return view('admin.gallery.view',[
            'data'=>$data,
            'imgs'=>$imgs
        ]);
    }

    public function filter(Request $request)
    {
        $data=Gallery::select('*');
            return Datatables::of($data)
            ->filter(function($data)use($request){
                if($request->has('title') && !empty($request->title)) 
                {
                    $data=$data->where('title','like','%'.$request->title.'%');
                }	
                })
                ->addIndexColumn()
                ->addColumn('title',function($data){
                    return ucfirst($data->title);
                    // if($data->image!='')
                    // {
                    //     return '<img  src="'.asset('/public/Images').'/'.$data->image.'" style="width:30px;height:30px">';          
                    // }
                })
                ->rawColumns(['image','action'])
                ->addColumn('action',function($data){
                    $edit=url('gallery').'/'.$data->id.'/edit';
                    $view=url('gallery').'/'.$data->id;
                        return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                        <a href="'.$edit.'" <i class="ri-pencil-fill fs-16 text-primary"></i></a></button>
                        <button type="button" value="'.$data->id.'" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>';  
                })
                ->setRowId(function ($data) {
                    return "row_".$data->id;
                })
                ->make(true);
    }

    public function getImages(Request $request)
    {
        $data=Gallery::get();
        return view('admin.gallery.image',[
            'data'=>$data
        ]);
    }

    public function deleteImage($id)
    {
        $item=GalleryImg::find($id);
        $item->delete();
        echo 1;
    }
}
