<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Banner;
use App\Models\Product;
use App\Models\Client;
use App\Models\ContactUs;
use App\Models\Enquiry;
use App\Models\Career;
use App\Models\Application;

use App\Models\Testimonial;
use Illuminate\Support\Facades\Mail;
class FrontendController extends Controller
{
    public function index()
    {
        $banners=Banner::get();
        $products=Product::orderBy('position','asc')->take(3)->get();
        $testimonials=Testimonial::get();
        $clients=Client::get();
        return view('front.index',[
            'banners'=>$banners,
            'products'=>$products,
            'testimonials'=>$testimonials,
            'clients'=>$clients,
        ]);
    }
    public function products()
    {
        $products=Product::orderBy('position','asc')->get();
        $clients=Client::get();
        return view('front.products',[
            'products'=>$products,
            'clients'=>$clients,
        ]); 
    }
    public function productsDetails($slug)
    {
        $product=Product::where('slug',$slug)->first();
        // Seo::title($product->product_name); // Example method
        // Seo::description(\Illuminate\Support\Str::limit(strip_tags($product->description), 160)); 
        // Seo::keywords('Product, ' . $product->product_name);
        return view('front.product-details',[
            'product'=>$product
        ]);
    }
    public function aboutUs()
    {
        $testimonials=Testimonial::get();
        $clients=Client::get();
        return view('front.about',[
            'testimonials'=>$testimonials,
            'clients'=>$clients,
        ]);  
    }
    public function clients()
    {
        $clients=Client::get();
        return view('front.clients',[
            'clients'=>$clients
        ]);  
    }
    public function contact()
    {
        return view('front.contact');  
    }
    public function storeContactForm(Request $request)
    {
        
        $request->validate([
            'name' => 'required',
            'contact_no' => 'required',
            'message' => 'required',
        ],[
            'name.required'=>'Please Enter Your Name',
            'contact_no.required'=>'Please Enter Phone Number',
            'message.required'=>'Please Enter Message',
        
        ]);
        $data=new ContactUs();
        $data->name=$request->name;
        $data->contact_no=$request->contact_no;
        $data->email=$request->email;
        $data->message=$request->message;
        $data->save();
        if (!empty($data->email)) {
            Mail::send('admin.contactUs.email', ['data' => $data], function ($message) use ($data) {
                $message->to($data->email)
                    ->subject('Thank You for Your Inquiry')
                    ->from('admin@petrol.com', 'Global Drilling Supplies');
            });
        }
        $response = [
            'message' => 'Your message has been submitted successfully! We will get back to you soon.',
        ];
        return response()->json($response);

    }
    public function storeEnquiryForm(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'contact_no' => 'required',
            'message' => 'required',
        ],[
            'name.required'=>'Please Enter Your Name',
            'contact_no.required'=>'Please Enter Phone Number',
            'message.required'=>'Please Enter Message',
        
        ]);
        $data=new Enquiry();
        $data->product_id=$request->id;
        $data->name=$request->name;
        $data->phone=$request->contact_no;
        $data->email=$request->email;
        $data->message=$request->message;
        $data->save();
        $response = [
            'message' => 'Your message has been submitted successfully! We will get back to you soon.',
        ];
        return response()->json($response);  
    }
    public function career()
    {
        $data=Career::get();
        return view('front.career',[
           'data'=>$data 
            ]);
    }
    public function storeCareerForm(Request $request)
    {
        // dd($request);
        $data=new Application();
        $data->career_id=$request->id;
        $data->name=$request->name;
        $data->email=$request->email;
        $data->phone=$request->contact_no;
        // dd($request->hasFile('resume'));
         if ($request->hasFile('resume')) {
            $file = ($request->file('resume'));
            $name = time() . '.' . str_replace(' ', '', $file->extension());
            $path = public_path('/images/resume');
            $file->move($path, $name);
            $data->resume = $name;
        }
        $data->created_at=date('Y-m-d H:i:s');
        $data->updated_at=date('Y-m-d H:i:s');
        $data->save();
        
        return response()->json(['status'=>true,'message'=>'Applied...!']);
    }
    
    
}
