<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Enquiry;
use App\Models\Product;
use DataTables;
class EnquiryController extends Controller
{
    
    public function index()
    {
        return view('admin.enquiry.index');
    }
    public function filter(Request $request)
    {
        $data=Enquiry::with('product')->select('*');
            return Datatables::of($data)
            ->filter(function($data)use($request){
                if($request->has('name') && !empty($request->name)) 
                {
                    $data=$data->where('name','like','%'.$request->name.'%');
                }
                if($request->has('email') && !empty($request->email)) 
                {
                    $data=$data->where('email','like','%'.$request->email.'%');
                }
                if($request->has('phone') && !empty($request->phone)) 
                {
                    $data=$data->where('phone','like','%'.$request->phone.'%');
                }   	
                })
                ->addIndexColumn()
                ->addColumn('name',function($data){
                    return ucfirst($data->name);
                })
               ->addColumn('product', function($data) {
    return isset($data->product) && !empty($data->product->product_name) 
           ? ucfirst($data->product->product_name) 
           : 'N/A'; // or return a default value like 'N/A'
})
                ->addColumn('phone',function($data){
                    return ucfirst($data->phone);
                })               
                ->addColumn('message',function($data){
                    return ucfirst($data->message);
                })
                ->rawColumns(['name','company_name','job_title','email','phone','message','action'])
                ->addColumn('action',function($data){
                    $edit=url('contact-us').'/'.$data->id.'/edit';
                    $view=url('enquiry').'/'.$data->id;
                        return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                        <button type="button" value="'.$data->id.'" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>';  
                })
                ->setRowId(function ($data) {
                    return "row_".$data->id;
                })
                ->make(true);
    }
    
    public function create()
    {
        //
    }

    
    public function store(Request $request)
    {
        //
    }

    
    public function show($id)
    {
        $data=Enquiry::find($id);
        $product=Product::find($data->product_id);
        return view('admin.enquiry.view',[
            'data'=>$data,
            'product'=>$product,
        ]);
    }

    
    public function edit($id)
    {
        //
    }

    
    public function update(Request $request, $id)
    {
        //
    }

    
    public function destroy($id)
    {
        //
    }
}
