<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactUs;
use App\Models\User;
use DataTables;

class ContactUsController extends Controller
{
    public function index()
    {
        $data=ContactUs::get();
        return view('admin.contactUs.index',[
            'data'=>$data
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'contact_no' => 'required',
        ]);
        $data=new ContactUs();
        $data->name=$request->name;
        $data->company_name=$request->company_name;
        $data->job_title=$request->job_title;
        $data->email=$request->email;            
        $data->contact_no=$request->contact_no;
        $data->message=$request->message;
        $data->save();
        return redirect('contact-us');
    }

    public function show($id)
    {
        $data=ContactUs::find($id);
        return view('admin.contactUs.view',[
            'data'=>$data
        ]);
    }
    public function destroy($id)
    {
        $data=ContactUs::find($id);
        $data->delete();
        echo 1;
    }
    public function filter(Request $request)
    {
        $data=ContactUs::select('*');
            return Datatables::of($data)
            ->filter(function($data)use($request){
                if($request->has('name') && !empty($request->name)) 
                {
                    $data=$data->where('name','like','%'.$request->name.'%');
                }
                if($request->has('email') && !empty($request->email)) 
                {
                    $data=$data->where('email','like','%'.$request->email.'%');
                }   	
                })
                ->addIndexColumn()
                ->addColumn('name',function($data){
                    return ucfirst($data->name);
                })
                ->addColumn('email',function($data){
                    return ucfirst($data->email);
                })
                ->addColumn('contact_no',function($data){
                    return ucfirst($data->contact_no);
                })               
                ->addColumn('message',function($data){
                    return ucfirst($data->message);
                })
                ->rawColumns(['name','company_name','job_title','email','contact_no','message','action'])
                ->addColumn('action',function($data){
                    $edit=url('contact-us').'/'.$data->id.'/edit';
                    $view=url('contact-us').'/'.$data->id;
                        return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                        <button type="button" value="'.$data->id.'" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>';  
                })
                ->setRowId(function ($data) {
                    return "row_".$data->id;
                })
                ->make(true);
    }
}
