<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;
use DataTables;
use Str;

class ClientController extends Controller
{
    
    public function index()
    {
        return view('admin.client.index');
    }
    public function filter(Request $request)
    {
        if($request->ajax()){
          $data = Client::select('*');
          if($request->has('client_name') && !empty($request->client_name))
          {
            $data=$data->where('client_name','like','%'.$request->client_name.'%');
          }
          if($request->has('client_phone') && !empty($request->client_phone))
          {
            $data=$data->where('client_phone','like','%'.$request->client_phone.'%');
          }
          $data=$data->get();  
          return Datatables::of($data)

                ->addIndexColumn()
                ->addColumn('client_name', function($data) { return ucfirst($data->client_name); })
                ->addColumn('logo', function($data) { 
                        return '<img  src="'.asset('/public/images/client').'/'.$data->logo.'" style="width:50px;height:50px">';
                    })
                ->rawColumns(['logo','client_name','action'])
                ->addColumn('action',function($data){
                  $edit=url('clients').'/'.$data->id.'/edit';
                  $view=url('clients').'/'.$data->id;
                      return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                      <a href="'.$edit.'" <i class="ri-pencil-fill fs-16 text-primary"></i></a></button>
                      <button type="button" value="'.$data->id.'" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>';  
              })
                ->setRowId(function ($data) {
                     return "row_".$data->id;
               })
                ->make(true);
        }
    }
   
    public function create()
    {
        return view('admin.client.create');
    }

   
    public function store(Request $request)
    {
        $request->validate([
            'client_name'=>'required',
            'client_phone'=>'required',
            'client_address'=>'required',
            'logo'=>'required'
          ]);
       
          $data= new Client();
          $data->client_name=$request->client_name;
          $data->client_address = $request->client_address;
          $data->client_phone=$request->client_phone;
          $data->client_email=$request->client_email;
          if($request->hasFile('logo'))
            {
              $file = ($request->file('logo'));
              $name = time().'.'.str_replace(' ','',$file->getClientOriginalExtension());
              $path = public_path('/images/client'); 
              $file->move($path,$name);
              $data->logo=$name;
            }
            $data->save();
            return redirect('clients');
    }

    
    public function show($id)
    {
        $data=Client::find($id);
        return view('admin.client.view',[
        'data'=>$data]);
    }

    
    public function edit($id)
    {
        $data=Client::find($id);
        return view('admin.client.update',[
        'data'=>$data]);
    }

    
    public function update(Request $request, $id)
    {
        $request->validate([
            'client_name'=>'required',
            'client_phone'=>'required',
            'client_address'=>'required',
            'logo'=>'required'
          ]);
       
          $data=Client::find($id);
          $data->client_name=$request->client_name;
          $data->client_address = $request->client_address;
          $data->client_phone=$request->client_phone;
          $data->client_email=$request->client_email;
          if($request->hasFile('logo'))
            {
              $file = ($request->file('logo'));
              $name = time().'.'.str_replace(' ','',$file->getClientOriginalExtension());
              $path = public_path('/images/client'); 
              $file->move($path,$name);
              $data->logo=$name;
            }
            $data->save();
            return redirect('clients');
    }

    
    public function destroy($id)
    {
        $data =Client::find($id)->delete();
        echo 1;
    }
}
