<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use Str;
use DataTables;
class CategoryController extends Controller
{
	public function index()
	{
		return view('admin.category.index');
	}

	public function filter(Request $request)
    {
     
        if($request->ajax()){
          $data = Category::select('category.*');
         
          if($request->has('category_name') && !empty($request->category_name))
          {
            $data=$data->where('category_name','like','%'.$request->category_name.'%');
          }       
          $data=$data->get();  
          return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('category_name', function($data) { return $data->category_name; })
                ->addColumn('icon', function($data) { return '<img src="'.asset('public/images/category').'/'.$data->icon.'" style="width:50px;height:50px;">';

                   })  
                ->rawColumns(['category_name','icon','status','action','is_featured'])
                
				->addColumn('action',function($data){
					$edit=url('category').'/'.$data->id.'/edit';
					$view=url('category').'/'.$data->id;
						return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
						<a href="'.$edit.'" <i class="ri-pencil-fill fs-16 text-primary"></i></a></button>
						<button type="button" value="'.$data->id.'" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>';  
				})
                ->setRowId(function ($data) {
                     return "row_".$data->id;
               })
                ->make(true);
        }
    }
	public function create()
	{
		return view('admin.category.create');
	}
	public function store(Request $request)
	{
		$request->validate([
			'category_name'=>'required',
			'description'=>'required',
			'is_parent'=>'required',
		]);

		$model= new Category();
		$model->category_name=$request->input('category_name');
		$model->slug=Str::slug($request->category_name);
		$model->description=$request->input('description');
		$model->position=$request->input('position');
		$model->created_by=\Auth::user()->id;
		$model->updated_by=\Auth::user()->id;
		$model->created_at=date('Y-m-d H:i:s');
		$model->updated_at=date('Y-m-d H:i:s');
		$model->is_parent=$request->input('is_parent');
		if($request->input('is_parent')=='yes')
		{
			$model->parent_category_id=0;
		}else
		{
			$model->parent_category_id=$request->parentcategory;
		}
		$path=public_path().'/images/category';
        if($files=$request->file('category_icon'))
        {
        	$time = date("Y-m-d")."-".time() ;
        	$name=$time.'-'.str_replace(' ','',$files->getClientOriginalName());
        	$files->move($path,$name);
        	$model->icon=$name;
        }
		$model->save();

		return redirect('category');

	}
	
	public function edit($id)
	{
		
		$data=Category::find($id);
		$parent=Category::select('*')->where('is_parent','yes')->get();
		return view('admin.category.update',[
			'data'=>$data,
			'categorylist'=>$parent
		]);
	}
	public function update(Request $request)
	{
		$request->validate([
			'category_name'=>'required',
			'description'=>'required',
			'is_parent'=>'required',
		]);
        // dd($request);
		$data=Category::find($request->id);
		if($data->category_name!=$request->category_name)
		{
			$data->slug=Str::slug($request->category_name);
		}
		$data->category_name=$request->input('category_name');
		$data->description=$request->input('description');
		$data->position=$request->input('position');
		$data->updated_by=\Auth::user()->id;
		$data->updated_at=date('Y-m-d H:i:s');
		$data->is_parent=$request->input('is_parent');
		if($request->input('is_parent')=='yes')
		{
			$data->parent_category_id=0;
		}else
		{
			$data->parent_category_id=$request->parentcategory;
		}
		$path=public_path().'/images/category';
        if($files=$request->file('category_icon'))
        {
        	$time = date("Y-m-d")."-".time() ;
        	$name=$time.'-'.str_replace(' ','',$files->getClientOriginalName());
        	$files->move($path,$name);
        	$data->icon=$name;
        }
		$data->save();
		return redirect('category');
	}
	public function show($id)
	{
		// dd($id);
		$data=Category::find($id);
		return view('admin.category.view',[
			'data'=>$data
		]);
		

	}
	public function destroy($id)
	{
		$data=Category::find($id)->delete();
		echo 1;
	}
	
	
	public function fetchCategory()
	{
		$data=Category::select('*')->where('is_parent','yes')->get();
		$test='';
		if($data){
	        $test .='<label class="form-label">Parent Category</label><select name="parentcategory" class="form-control" required=""><option value="">Choose parent Category</option>';
				foreach($data as $row)
				{
					$test.= '<option value="'.$row->id.'">'.$row->category_name.'</option>';
				}			
			$test.='</select>';
			
			echo $test;

		}else{
	
			echo $test;
		}
		//echo "<pre>";echo $test;exit;
	}
	
}
?>