<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Career;
use DataTables;
use App\Models\Application;
class CareerController extends Controller
{
    public function index()
    {
        $data=Career::get();
        // dd($data);
        return view('admin.career.index',[
            'data'=>$data
        ]);
    }

    public function create()
    {

        return view('admin.career.create');
    }

    public function store(Request $request)
    {
      
        $data=new Career();
        $data->role=$request->role;
        $data->description=$request->description;       
        $data->experience=$request->experience;       
        // if ($request->hasFile('image')) {
        //     $file = $request->file('image');
        //     $name = $file->getClientOriginalName();
        //     $path = public_path('image');
        //     $file->move($path, $name);
        //     $data->image = $name;
        // }
        $data->save();
        return redirect('career');
    }

    public function edit($id)
    {
        $data=Career::find($id);
        return view('admin.career.edit',[
            'data'=>$data
        ]);
    }

    public function update(Request $request,$id)
    {
        $data=Career::find($id);
        $data->role=$request->role;
        $data->description=$request->description;       
        $data->experience=$request->experience;       
   
        $data->save();
        return redirect('career');
       
    }

    public function destroy($id)
    {
        $data=Career::find($id);
        $data->delete();
        echo 1;
    }


    public function show($id)
    {
        $data=Career::find($id);
        return view('admin.career.view',[
            'data'=>$data
        ]);
    }

    public function filter(Request $request)
    {
        $data=Career::select('*');
            return Datatables::of($data)
            ->filter(function($data)use($request){                	
                if($request->has('role') && !empty($request->role)) 
                {
                    $data=$data->where('role','like','%'.$request->role.'%');
                }     
                })
                ->addIndexColumn()
                ->addColumn('role',function($data){
                    return ucfirst($data->role);
                })                
                //     ->addColumn('image', function ($data) {
                //     if ($data->image != '') {
                //         return '<img src="' . asset('public/images') . '/' . $data->image . '" style="width:25px; height:25px;">';
                //     }
                // })
                ->rawColumns(['role','action'])
                ->addColumn('action',function($data){
                    
                    $edit=url('career').'/'.$data->id.'/edit';
                    $view=url('career').'/'.$data->id;
                   $applications = url('career') . '/' . $data->id . '/view-applications';
                        return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                        <a href="'.$edit.'" <i class="ri-pencil-fill fs-16 text-primary"></i></a></button>
                        <button type="button" value="'.$data->id.'" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>
                         <a href="'.$applications.'" title="View Applications"><i class="ri-file-list-2-fill fs-16 text-secondary"></i></a>
                        ';   
                })
                ->setRowId(function ($data) {
                    return "row_".$data->id;
                })
                ->make(true);
    }
    public function viewApplications($id)
    {
        
        $career = Career::findOrFail($id);
        return view('admin.career.applications', compact('career'));
    }
    
    public function applicationsfilter(Request $request)
    {
        $data=Application::where('career_id',$request->careerId)->select('*')->orderBy('created_at','desc');
            return Datatables::of($data)
            ->filter(function($data)use($request){                	
                if($request->has('name') && !empty($request->name)) 
                {
                    $data=$data->where('name','like','%'.$request->name.'%');
                }     
                })
                ->addIndexColumn()
                ->addColumn('name',function($data){
                    return ucfirst($data->name);
                })                
               
                ->rawColumns(['name','action'])
                ->addColumn('action',function($data){
                   $download = url('career') . '/' . $data->id . '/download';
                        return '
                       
                        
                         <a href="'.$download.'" title="View Applications"><i class="ri-download-fill fs-16 text-secondary"></i></a>
                        ';   
                })
                ->setRowId(function ($data) {
                    return "row_".$data->id;
                })
                ->make(true);
    }
    public function applicationsdownload($id)
    {
       $application = Application::findOrFail($id); 
       $fileName = $application->resume;
      $path = public_path('images/resume/' . $fileName);
        if (file_exists($path)) {
            // Return the file as a download response
            return response()->download($path);
        } else {
            // Return an error if the file is not found
            return redirect()->back()->with('error', 'File not found.');
        }
    }
}
