<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Banner;
use DataTables;
use Str;

class BannerController extends Controller
{
    
    public function index()
    {
        return view('admin.banner.index');
        
    }

    public function filter(Request $request)
    {
        if($request->ajax()){
          $data = Banner::select('banner.*');
          if($request->has('title') && !empty($request->title))
          {
            $data=$data->where('title','like','%'.$request->title.'%');
          }
         
          $data=$data->get();  
          return Datatables::of($data)

                ->addIndexColumn()
                ->addColumn('title', function($data) { return ucfirst($data->title); })
                ->addColumn('image', function($data) { 
                        return '<img  src="'.asset('/public/images/banner').'/'.$data->image.'" style="width:50px;height:50px">';
                    })
                ->rawColumns(['image','title','action'])
                ->addColumn('action',function($data){
                  $edit=url('banner').'/'.$data->id.'/edit';
                  $view=url('banner').'/'.$data->id;
                      return '<a href="'.$view.'" <i class="ri-eye-fill fs-16 text-info"></i></a></button>
                      <a href="'.$edit.'" <i class="ri-pencil-fill fs-16 text-primary"></i></a></button>
                      <button type="button" value="'.$data->id.'" class="delete-button" style="border: none; background: none;"><i class="ri-delete-bin-5-fill fs-16 text-danger"></i></button>';  
              })
                ->setRowId(function ($data) {
                     return "row_".$data->id;
               })
                ->make(true);
        }
    }

    public function create()
    {
       return view('admin.banner.create');
    }

     public function store(Request $request)
    {
     
      $request->validate([
        'title'=>'required',
        'position'=>'required',
        'image'=>'required'
      ]);
   
      $data= new Banner();
      $data->title=$request->title;
      $data->position = $request->position;
      $data->description=$request->description;
      if($request->hasFile('image'))
        {
          $file = ($request->file('image'));
         $name = time().'.'.str_replace(' ','',$file->getClientOriginalExtension());
          $path = public_path('/images/banner'); 
          $file->move($path,$name);
          $data->image=$name;
        }
        $data->save();

        return redirect('banner');
    }
    public function edit($id)
    {
       $data=Banner::find($id);
       return view('admin.banner.update',[
        'data'=>$data]);
    }

    public function update(Request $request)
    {
      $request->validate([
        'title'=>'required',
        'position="required'
      ]);
       $data =Banner::find($request->id);
       $data->title = $request->title;
       $data->description = $request->description;
       $data->position=$request->position;
       if($request->hasFile('image'))
        {
          $file = ($request->file('image'));
          $name = time().'.'.str_replace(' ','',$file->getClientOriginalExtension());
          $path = public_path('images/banner'); 
          $file->move($path,$name);
          $data->image=$name;
        }
        $data->save();
        return redirect('banner');
    }

    public function show($id)
    {
      $data=Banner::find($id);
      return view('admin.banner.view',[
        'data'=>$data, 
      ]);
      
    }
    public function destroy($id)
    {
      $data =Banner::find($id)->delete();
      echo 1;
    }
    
  
    
}
