@extends('layouts.adminlayouts')
@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Create</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                    <li class="breadcrumb-item"><a href="{{ url('career') }}">Careers</a></li>
                                    <li class="breadcrumb-item active">Create</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="{{ route('career.store') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <div class="col-xxl-6 col-md-3">
                                                <div>
                                                    <label>Role</label>
                                                    <input type="text" class="form-control" name="role" id="role"
                                                        placeholder="Role" required>
                                                    @error('role')
                                                        <div class="text-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>      
                                            
                                            <div class="col-xxl-6 col-md-3">
                                                <div>
                                                    <label>Experience</label>
                                                    <input type="text" class="form-control" name="experience" id="experience"
                                                        placeholder="Experience" required>
                                                    @error('experience')
                                                        <div class="text-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div> 
                                            
                                      
                                            <div class="col-xxl-12 col-md-12">
                                                <div>
                                                    <label>Description</label>
                                                    <textarea type="text" class="form-control" name="description" id="description" placeholder="Description" required></textarea>
                                                    @error('description')
                                                        <div class="text-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>                                                                                   
                                        </div>
                                    </div>
                                    <div class="col-md-12 mb-3 text-end mt-5">
                                        <button type="submit" class="btn  btn-success ">Submit</button>
                                        <a class="btn  btn-secondary" href="{{ url('career') }}">Back</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection()
