<?php 
	/*	
	*	Goodlayers Getting Start Page
	*	---------------------------------------------------------------------
	*	This file that creates getting start page
	*	---------------------------------------------------------------------
	*/	

	if( class_exists('gdlr_core_getting_start') ){
		new gdlr_core_getting_start(array(
			'parent-slug' => 'goodlayers_main_menu',
			'page-title' => esc_html__('Getting Start / Import', 'realfactory'),
			'menu-title' => esc_html__('Getting Start / Import', 'realfactory'),
			'capability' => 'edit_theme_options'
		));
	}

	add_filter('gdlr_core_getting_start_option', 'realfactory_gdlr_core_getting_start_option', 10, 2);
	if( !function_exists('realfactory_gdlr_core_getting_start_option') ){
		function realfactory_gdlr_core_getting_start_option( $options, $slug ){
			if( $slug == 'gdlr_core_getting_start' ){

				$content = array();

				// install plugins link
				$plugins_complete = realfactory_tgmpa_complete();
				if( !$plugins_complete ){
					$content['required-plugins'] = array(
						'title' => esc_html__('Required Plugins', 'realfactory'),
						'type' => 'page',
						'content' => '<p>' . wp_kses(__('<strong>Before moving on, please make sure that all required plugins are installed and activated</strong><br>This is very important step to make the theme run properly.', 'realfactory'), array('strong'=>array(), 'br'=>array()) ) . 
							'</p><a class="gdlr-core-button" href="' . esc_attr(admin_url('themes.php?page=tgmpa-install-plugins')) . '" >' . esc_html__('Install Required Plugins', 'realfactory') . '</a>' .
							'<h3>' . esc_html__('1. Install plugins then click on \'Return To Require Plugins Installer', 'realfactory') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin1.jpg') . '" alt="" />' .
							'<h3>' . esc_html__('2. Activate plugins', 'realfactory') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin2.jpg') . '" alt="" />'
					);
				}

				// guidelines
				$content['guidelines'] = array(
					'title' => esc_html__('Guidelines', 'realfactory'),
					'type' => 'page',
					'content' => 
						wp_kses(__('<h4>1.) Installation</h4>', 'realfactory'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/fnuorj61ib8?list=PLNIFTA4Bjp3u5yqDz390MNRrjhnyzWVnY" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>2.) Importing Demo</h4>', 'realfactory'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/DWOC7bHdUuU?list=PLNIFTA4Bjp3u5yqDz390MNRrjhnyzWVnY" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>3.) Creating Portfolio</h4>', 'realfactory'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/XFrtHJuPW_4" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>4.) Creating Personnel</h4>', 'realfactory'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/MwFxxSlYuAA" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>5.) Creating Blog</h4>', 'realfactory'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/fqcdMzTjvrE" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>6.) Goodlayers Page Builder</h4>', 'realfactory'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/N0haJbDM8ac" frameborder="0" allowfullscreen></iframe>'
				);

				// import demo
				$content['import-demo'] = array(
					'title' => esc_html__('Import Demo', 'realfactory'),
					'type' => 'demo',
					'content' => wp_kses(__('<strong>Get import error?</strong> Please make sure that your server has PHP max_execution_time at least 300, memory_limit at least 300. You may set these values temporaly and change it back after finish importing.', 'realfactory'), array('strong'=>array(), 'br'=>array())),
					'demo-content' => wp_kses(
						__('<strong>Main demo</strong> - include all pages shown in demo such as elements, features, about us, services contact, all portfolio pages, all blog pages. It\'s 100+ pages and 30+ images in total.', 'realfactory') . '<br><br>', 
						// __('<strong>Main demo (Lite verion)</strong> - include about us, services, few portfolios, few blog pages. Element and feature page are not included.', 'realfactory') . '<br><br>' . 
						// __('Please also be cautious that over 1000+ images will be generated in main demo.', 'realfactory'), 
						array('strong'=>array(), 'br'=>array())),
				);

				// system status
				$content['system-status'] = array(
					'title' => esc_html__('System Status', 'realfactory'),
					'type' => 'system-status',
					'content' => wp_kses(__('<strong>To import demo content</strong>, PHP max_execution_time at least 300 secs and  memory_limit at least 256MB is recommended. <strong><br>If you\'re importing main demo (Full Version)</strong>, PHP max_input_vars is recommended to be at least 4000.', 'realfactory'), array('strong'=>array(), 'br'=>array()))
				);

				// obtain product validation link
				if( !empty($GLOBALS['tgmpa']) ){
					$plugin_slug = 'envato-market';
					$plugin_url = 'admin.php?page=envato-market';
					$product_validation_url = realfactory_tgmpa_auto_install_url($plugin_slug,  $plugin_url);

					$tgmpa = call_user_func(array(get_class($GLOBALS['tgmpa']), 'get_instance'));
					if( !$tgmpa->is_plugin_installed($plugin_slug) ){
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'realfactory'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates, you need to install and activate the plugin \'Envato Market\'</strong>.<br>You\'ll also need API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'realfactory'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Get envato market plugin now!', 'realfactory') . '</a>'
						);
					}else{
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'realfactory'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates</strong>, you need to fill the infomation in \'Envato Market\' plugin page.<br>You need to retrieve API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'realfactory'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Go to plugin settings!', 'realfactory') . '</a>'
						);
					}
				}

				// support
				$content['support'] = array(
					'title' => esc_html__('Support', 'realfactory'),
					'type' => 'page',
					'content' => wp_kses(__('<p><strong>Have questions about how to use the theme?</strong></p><p>Make sure that you read all through the document we provided. The document is contained in main package that you downloaded from Themeforest. It\'s in the folder \'Document-Instruction\', open the file \'index.html\' with your browser. Or you can view online document here.</p>', 'realfactory'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
						'<a class="gdlr-core-button" target="_blank" href="#" >' . esc_html__('View Online Document', 'realfactory') . '</a><br><br>' .
						wp_kses(__('<p><strong>Have problems or can\'t find answer in the document?</strong></p><p>1. Make sure that you are running the latest version of the theme.<br>2. Make sure that you deeply checked theme\'s instruction and try to search for public tickets in case of someone else asked the same question before. <br> 3. Try to deactivate all plugins (Except Goodlayers plugins) and see if the problem resolved or not.</p>', 'realfactory'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) .
						wp_kses(sprintf(__('<p>After doing these steps and still see the problem, feel free to submit tickets in our support website. Our supporter are happy to help you.<br><strong>Please note that you will need Purchase code to submit the ticket</strong> - <a href="%s" target="_blank" >How to get purchased code?</a></p>', 'realfactory'), 'https://help.market.envato.com/hc/en-us/articles/202822600'), array('strong'=>array(), 'br'=>array(), 'p'=> array(), 'a'=>array('href'=>array(), 'target'=>array())) ) .
						'<a class="gdlr-core-button" target="_blank" href="http://support.goodlayers.com" >' . esc_html__('Go to support website', 'realfactory') . '</a>'
				);

				return array(
					'header' => array(
						'logo' => get_template_directory_uri() . '/images/getting-start/header.png',
						'title' => esc_html__('Congratulations !', 'realfactory'),
						'caption' => '<strong>' . esc_html__('Real Factory', 'realfactory') . '</strong> ' . esc_html__('WordPress theme is now installed and ready to use. Thank you so much for choosing Goodlayers!', 'realfactory')
					),
					'content' => $content
				);
			}

			return $options;
		}
	}

	// add filter for demo import
	add_filter('gdlr_core_demo_options', 'realfactory_gdlr_core_demo_options');
	if( !function_exists('realfactory_gdlr_core_demo_options') ){
		function realfactory_gdlr_core_demo_options($demo){
			return array(
				'realfactory' => array(
					'title' => esc_html__('Real Factory', 'realfactory'),
					'url' => 'http://demo.goodlayers.com/realfactory/',
					'xml' => get_template_directory() . '/admin/function/files/realfactory.xml',
					'page' => 2039,
					'menu' => array('main_menu' => 45, 'mobile_menu' => 45),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Elements","id":"elements"},{"name":"Blog","id":"blog"},{"name":"Blog Left","id":"blog-left"},{"name":"Blog Right","id":"blog-right"},{"name":"Market Sectors","id":"market-sectors"},{"name":"Shop","id":"shop"}],"sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-3"],"footer-2":["nav_menu-4"],"footer-3":["recent-posts-3"],"footer-4":["text-7"],"elements":[],"blog":["text-2","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-2"],"blog-left":["search-3","text-4","recent-posts-4","gdlr-core-portfolio-slider-widget-2"],"blog-right":["text-5","recent-comments-4","tag_cloud-4"],"market-sectors":["nav_menu-2","nav_menu-3","text-6"],"shop":["woocommerce_price_filter-2","woocommerce_product_categories-2","woocommerce_top_rated_products-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_bcn_widget":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"3","thumbnail-size":"Frame Landscape 2"},"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"9"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"2":{"title":"Market Sectors","nav_menu":69},"3":{"title":"Useful Links","nav_menu":70},"4":{"title":"Market Sectors","nav_menu":69},"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"4":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"3":{"title":"","number":5,"show_date":false},"4":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"4":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"3":{"title":"","text":"[gdlr_core_space height=\"-2px\"]\r\n<img src=\"http:\/\/demo.goodlayers.com\/realfactory\/wp-content\/uploads\/2016\/09\/logo-white.png\" alt=\"\"\/> \r\n[gdlr_core_space height=\"7px\"]\r\n\r\nFar far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. \r\n","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_button button-text=\"Get A Quote\" border-radius=\"3px\" background-color=\"#222\" button-background=\"solid\" button-link=\"http:\/\/demo.goodlayers.com\/realfactory\/contact\/\" button-link-target=\"_parent\" margin-right=\"20px\" ]","filter":false},"7":{"title":"Contact Info","text":"[gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"20px\" color=\"#f7c02e\" margin-left=\"0px\" margin-right=\"10px\" ] 12 Main Street Pt. London \r\n[gdlr_core_space height=\"-6px\"]\r\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"20px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +44 3656 4567 \r\n[gdlr_core_space height=\"-6px\"]\r\n[gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"20px\" color=\"#f7c02e\" margin-left=\"0px\" margin-right=\"10px\" ] contact@realfactoryWP.com\r\n\r\n","filter":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"2":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"2":{"title":"Product Categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"2":{"title":"Top Rated Products","number":5},"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_wpgmza_map_widget":{"_multiwidget":1}}',
					'theme-option' => '{"rftr_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"[gdlr_core_dropdown_tab]\n\n[gdlr_core_tab title=\"Hamburg\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +49 3656 4567 [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"24px\" margin-right=\"10px\" ] Mon - Fri 09:00 - 17:00  [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"24px\" margin-right=\"10px\" ]12 Main Street Pt. Hamburg Germany\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"New York\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 2223 4567 [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"24px\" margin-right=\"10px\" ] Mon - Fri 09:00 - 17:00 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"24px\" margin-right=\"10px\" ]4th Avenue Kingston St. New York \n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"San Francisco\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 8887-3342 [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"24px\" margin-right=\"10px\" ] Mon - Fri 09:00 - 17:00 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"24px\" margin-right=\"10px\" ]55th Floor Paulsson Bd. SF[\/gdlr_core_tab]\n\n[\/gdlr_core_dropdown_tab]","top-bar-right-text":"","top-bar-top-padding":"16px","top-bar-bottom-padding":"14px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"#","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"","top-bar-social-snapchat":"","header-style":"bar","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"82","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"23px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"53px","logo":"","mobile-logo":"","logo-top-padding":"50px","logo-bottom-padding":"45px","logo-left-padding":"","max-logo-width":"241px","main-navigation-top-padding":"23px","main-navigation-bottom-padding":"23px","main-navigation-right-padding":"","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-type":"right","right-menu-style":"hamburger-with-border","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-transform":"none","default-title-font-size":"55px","default-title-font-weight":"","default-title-letter-spacing":"0px","default-caption-font-size":"18px","default-caption-font-weight":"","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"title-background","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"50","blog-sidebar":"right","blog-sidebar-left":"footer-1","blog-sidebar-right":"blog","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","meta-option":["author","category","tag","comment-number"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"enable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"blog","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"shop","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"Frame Port Portait","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"Frame Port Portait","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-top-padding":"70px","footer-bottom-padding":"50px","footer-style":"footer-2","enable-copyright":"enable","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-text":"Copyright 2020 GoodLayers, All Right Reserved","enable-back-to-top":"disable","logo-right-box1-icon":"icon_check_alt2","logo-right-box1-title":"Ceritified","logo-right-box1-caption":"ISO 9001:2008","logo-right-box2-icon":"icon_check_alt2","logo-right-box2-title":"The Best","logo-right-box2-caption":"#1 in Germany","logo-right-box3-icon":"icon_check_alt2","logo-right-box3-title":"Number #1","logo-right-box3-caption":"Suplier in region","enable-header-right-button":"enable","header-right-button-text":"Get A Quote","header-right-button-link":"http:\/\/demo.goodlayers.com\/realfactory\/contact\/","header-right-button-link-target":"_self","enable-default-breadcrumbs-on-page":"disable","enable-default-breadcrumbs-on-portfolio":"disable","enable-default-breadcrumbs-on-post":"enable","enable-breadcrumbs-on-archive":"disable"},"rftr_typography":{"heading-font":"Hind","navigation-font":"Hind","content-font":"Hind","info-font":"Hind","blog-info-font":"Hind","quote-font":"Droid Serif","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"600","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"rftr_color":{"page-preload-background-color":"#ffffff","top-bar-background-color":"#ededed","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#727272","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#2e2e2e","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#000000","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#ffbe32","logo-background-color":"#ffffff","navigation-bar-right-icon-color":"#ffffff","woocommerce-cart-icon-number-background":"#e8b62d","woocommerce-cart-icon-number-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#f8c12c","breadcrumbs-text-color":"#898989","breadcrumbs-text-active-color":"#545454","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#0e0e0e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-menu-text-hover-background-color":"#0e0e0e","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#303030","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#727272","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#161616","sidebar-link-color":"#a3a3a3","sidebar-link-hover-color":"#ddb42c","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","footer-background-color":"#242424","footer-title-color":"#f8c12c","footer-content-color":"#f7f7f7","footer-link-color":"#b2b2b2","footer-link-hover-color":"#f8c12c","footer-divider-color":"#474747","copyright-background-color":"#131313","copyright-text-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#d8d8d8","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#2b2b2b","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#f1bf37","blog-sticky-banner-color":"#262626","blog-sticky-banner-background":"#f1bf37","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#9b9b9b","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#f2bd2b","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#190000","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-head-color":"#343434","portfolio-info-color":"#898989","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#f2bd2b","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#e8b62d","price-table-active-head-top-gradient-color":"#e8c35f","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff5c1","price-table-active-price-background-color":"#ececec","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#e8b62d","price-table-active-button-background-top-gradient-color":"#e8c668","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f8c12c","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#e8b62d","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#e8b62d","button-top-gradient-background-color":"#e8c158","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#212121","dropdown-tab-head-text":"#f7c02e","flipbox-background-color":"#e8b62d","flipbox-border-color":"#d39d1d","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#e8b62d","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#e8b62d","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#e8b62d","table-head-text-color":"#0c0c0c","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","woocommerce-theme-color":"#e8b62d","woocommerce-price-color":"#e8b62d","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#e8b62d","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#e8b62d","widget-price-filter-bar-background-color":"#d6d6d6","widget-price-filter-range-color":"#eaeaea","widget-price-filter-handle-color":"#cccccc","skin":[{"name":"Dark","title":"#ffffff","title-hover":"","caption":"#c4c4c4","content":"#d8d8d8","icon":"#ffffff","link":"#ffffff","link-hover":"#e6b52f","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#e6b52f","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"#e6b52f","button-border-hover-color":""},{"name":"Call to action","title":"#e6b52f","title-hover":"","caption":"","content":"#ffffff","icon":"","link":"#ebb727","link-hover":"#cc9322","divider":"","border":"","element-background":"","element-content":"","button-text":"#e6b52f","button-text-hover":"","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Double Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#f8c12c","button-text-hover":"#f8c12c","button-background":"#2d2d2d","button-background-hover":"","button-border-color":"#f8c12c","button-border-hover-color":"#f8c12c"},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#dddddd","divider":"#f2f2f2","border":"#ededed","element-background":"#ffffff","element-content":"#3f3f3f","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#191919","button-background-hover":"#3a3a3a","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"#000000","title-hover":"","caption":"#8c8c8c","content":"#a3a3a3","icon":"#000000","link":"#232323","link-hover":"#7c7c7c","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#232323","button-background-hover":"#232323","button-border-color":"","button-border-hover-color":""},{"name":"About Counter","title":"#ffffff","title-hover":"","caption":"#f8c12c","content":"#f8c12c","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Portfolio Homepage","title":"#000000","title-hover":"","caption":"#ffffff","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Link","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#d8a419","link-hover":"#f2b91d","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Service","title":"#000000","title-hover":"","caption":"","content":"#000000","icon":"","link":"#ffffff","link-hover":"#cecece","divider":"","border":"","element-background":"","element-content":"","button-text":"#191919","button-text-hover":"","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Call To action 2","title":"#000000","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#1e1e1e","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blog Homepage","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f7f7f7","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"header-right-title-color":"#191919","header-right-caption-color":"#929292","header-right-button-text-color":"#1c1c1c","header-right-button-background-color":"#f8c12c","breadcrumbs-background-color":"#efefef","blog-info-icon-color":"#f1bf37","blog-date-divider-color":"#f8c12c","mobile-menu-icon-color":"#383838","mobile-menu-border-color":"#dddddd"},"rftr_plugin":{"enable-srcset":"disable","lightbox":"ilightbox","ilightbox-skin":"dark","link-to-lightbox":"enable","additional-css":"\/*--Custom --*\/\n.realfactory-top-bar-right {\n    line-height: 32px;\n}\n","additional-mobile-css":"","additional-head-script":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"2700","enable-preload":"disable","preload-image":"","thumbnail-sizing":[{"name":"Square","width":"700","height":"700","hard-crop":""},{"name":"Frame Lanscape","width":"800","height":"420","hard-crop":""},{"name":"Frame Landscape 2","width":"800","height":"570","hard-crop":""},{"name":"Frame Portrait","width":"600","height":"750","hard-crop":""},{"name":"Frame Blog Full","width":"920","height":"415","hard-crop":""},{"name":"Frame Long","width":"900","height":"280","hard-crop":""},{"name":"Frame Port Portait","width":"500","height":"625","hard-crop":""}]}}'
				),
			);
		}
	}

	// add action when finish install plugins
	add_action('realfactory_tgmpa_no_item_redirect', 'realfactory_tgmpa_no_item_redirect');
	if( !function_exists('realfactory_tgmpa_no_item_redirect') ){
		function realfactory_tgmpa_no_item_redirect(){
			echo '<script type="text/javascript">';
			echo 'window.location = \'' . admin_url('admin.php?page=gdlr_core_getting_start') . '\';';
			echo '</script>';
		}
	}

	// install required plugin and redirect to getting start page
	add_action('after_switch_theme', 'realfactory_getting_start_redirect'); 	
	if( !function_exists('realfactory_getting_start_redirect') ){
		function realfactory_getting_start_redirect(){

			$default_theme_option = '{"rftr_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"16px","top-bar-bottom-padding":"14px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"#","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"","top-bar-social-snapchat":"","header-style":"bar","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"82","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"23px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"53px","logo":"","mobile-logo":"","logo-top-padding":"50px","logo-bottom-padding":"45px","logo-left-padding":"","max-logo-width":"241px","main-navigation-top-padding":"23px","main-navigation-bottom-padding":"23px","main-navigation-right-padding":"","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-type":"right","right-menu-style":"hamburger-with-border","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-transform":"none","default-title-font-size":"55px","default-title-font-weight":"","default-title-letter-spacing":"0px","default-caption-font-size":"18px","default-caption-font-weight":"","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"title-background","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"50","blog-sidebar":"right","blog-sidebar-left":"footer-1","blog-sidebar-right":"blog","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","meta-option":["author","category","tag","comment-number"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"enable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"blog","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"shop","woocommerce-archive-column-size":"20","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-top-padding":"70px","footer-bottom-padding":"50px","footer-style":"footer-2","enable-copyright":"enable","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-text":"Copyright 2020 GoodLayers, All Right Reserved","enable-back-to-top":"disable","logo-right-box1-icon":"","logo-right-box1-title":"","logo-right-box1-caption":"","logo-right-box2-icon":"","logo-right-box2-title":"","logo-right-box2-caption":"","logo-right-box3-icon":"","logo-right-box3-title":"","logo-right-box3-caption":"","enable-header-right-button":"disable","header-right-button-text":"Get A Quote","header-right-button-link":"http:\/\/demo.goodlayers.com\/realfactory\/contact\/","header-right-button-link-target":"_self","enable-default-breadcrumbs-on-page":"disable","enable-default-breadcrumbs-on-portfolio":"disable","enable-default-breadcrumbs-on-post":"enable","enable-breadcrumbs-on-archive":"disable"},"rftr_typography":{"heading-font":"Hind","navigation-font":"Hind","content-font":"Hind","info-font":"Hind","blog-info-font":"Hind","quote-font":"Droid Serif","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"600","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"rftr_color":{"page-preload-background-color":"#ffffff","top-bar-background-color":"#ededed","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#727272","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#2e2e2e","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#000000","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#ffbe32","logo-background-color":"#ffffff","navigation-bar-right-icon-color":"#ffffff","woocommerce-cart-icon-number-background":"#e8b62d","woocommerce-cart-icon-number-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","search-overlay-background-color":"#000000","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#f8c12c","breadcrumbs-text-color":"#898989","breadcrumbs-text-active-color":"#545454","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#0e0e0e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-menu-text-hover-background-color":"#0e0e0e","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#303030","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#727272","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#161616","sidebar-link-color":"#a3a3a3","sidebar-link-hover-color":"#ddb42c","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","footer-background-color":"#242424","footer-title-color":"#f8c12c","footer-content-color":"#f7f7f7","footer-link-color":"#b2b2b2","footer-link-hover-color":"#f8c12c","footer-divider-color":"#474747","copyright-background-color":"#131313","copyright-text-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#d8d8d8","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#2b2b2b","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#f1bf37","blog-sticky-banner-color":"#262626","blog-sticky-banner-background":"#f1bf37","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#9b9b9b","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#f2bd2b","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#828282","pagination-background-hover-color":"#190000","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-head-color":"#343434","portfolio-info-color":"#898989","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#f2bd2b","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#e8b62d","price-table-active-head-top-gradient-color":"#e8c35f","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#fff5c1","price-table-active-price-background-color":"#ececec","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#e8b62d","price-table-active-button-background-top-gradient-color":"#e8c668","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f8c12c","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#e8b62d","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#e8b62d","button-top-gradient-background-color":"#e8c158","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#212121","dropdown-tab-head-text":"#f7c02e","flipbox-background-color":"#e8b62d","flipbox-border-color":"#d39d1d","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#e8b62d","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#e8b62d","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#e8b62d","table-head-text-color":"#0c0c0c","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","woocommerce-theme-color":"#e8b62d","woocommerce-price-color":"#e8b62d","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#e8b62d","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#e8b62d","widget-price-filter-bar-background-color":"#d6d6d6","widget-price-filter-range-color":"#eaeaea","widget-price-filter-handle-color":"#cccccc","skin":[{"name":"Dark","title":"#ffffff","title-hover":"","caption":"#c4c4c4","content":"#d8d8d8","icon":"#ffffff","link":"#ffffff","link-hover":"#e6b52f","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#e6b52f","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"#e6b52f","button-border-hover-color":""},{"name":"Call to action","title":"#e6b52f","title-hover":"","caption":"","content":"#ffffff","icon":"","link":"#ebb727","link-hover":"#cc9322","divider":"","border":"","element-background":"","element-content":"","button-text":"#e6b52f","button-text-hover":"","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Double Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#f8c12c","button-text-hover":"#f8c12c","button-background":"#2d2d2d","button-background-hover":"","button-border-color":"#f8c12c","button-border-hover-color":"#f8c12c"},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#dddddd","divider":"#f2f2f2","border":"#ededed","element-background":"#ffffff","element-content":"#3f3f3f","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#191919","button-background-hover":"#3a3a3a","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"#000000","title-hover":"","caption":"#8c8c8c","content":"#a3a3a3","icon":"#000000","link":"#232323","link-hover":"#7c7c7c","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#232323","button-background-hover":"#232323","button-border-color":"","button-border-hover-color":""},{"name":"About Counter","title":"#ffffff","title-hover":"","caption":"#f8c12c","content":"#f8c12c","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Portfolio Homepage","title":"#000000","title-hover":"","caption":"#ffffff","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Link","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#d8a419","link-hover":"#f2b91d","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Service","title":"#000000","title-hover":"","caption":"","content":"#000000","icon":"","link":"#ffffff","link-hover":"#cecece","divider":"","border":"","element-background":"","element-content":"","button-text":"#191919","button-text-hover":"","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Call To action 2","title":"#000000","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#1e1e1e","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blog Homepage","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f7f7f7","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"header-right-title-color":"#191919","header-right-caption-color":"#929292","header-right-button-text-color":"#1c1c1c","header-right-button-background-color":"#f8c12c","breadcrumbs-background-color":"#efefef","blog-info-icon-color":"#f1bf37","blog-date-divider-color":"#f8c12c","mobile-menu-icon-color":"#383838","mobile-menu-border-color":"#dddddd"},"rftr_plugin":[]}';
			$default_theme_option = json_decode($default_theme_option, true);
			foreach( $default_theme_option as $option_slug => $option_value ){
				$option = get_option($option_slug, array());
				if( empty($option) ){
					update_option($option_slug, $option_value);
				}
			}

			// redirect to plugin installation
			$plugin_slug = 'goodlayers-core';
			$getting_start_url = 'admin.php?page=gdlr_core_getting_start';
			$redirect_url = realfactory_tgmpa_auto_install_url($plugin_slug,  $getting_start_url);
			
			if( empty($redirect_url) ){
				wp_redirect(admin_url('themes.php?page=tgmpa-install-plugins'));
			}else{
				wp_redirect($redirect_url);
			}

		}
	}