<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'realfactory_page_builder_body_class');
	if( !function_exists('realfactory_page_builder_body_class') ){
		function realfactory_page_builder_body_class( $classes ) {
			return $classes . ' realfactory-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'realfactory_gdlr_core_sidebar_class');
	if( !function_exists('realfactory_gdlr_core_sidebar_class') ){
		function realfactory_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' realfactory-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'realfactory_goodlayers_core_setup');
	if( !function_exists( 'realfactory_goodlayers_core_setup' ) ){
		function realfactory_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'realfactory_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'realfactory_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'realfactory_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'realfactory_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'realfactory_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'realfactory_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_related', 'realfactory_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'realfactory_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'realfactory_gdlr_core_portfolio_hover_icon_class');

			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'realfactory_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('realfactory_gdlr_core_privacy_settings') ){
		function realfactory_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = realfactory_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}

	// portfolio hover icon class
	if( !function_exists('realfactory_gdlr_core_portfolio_hover_icon_class') ){
		function realfactory_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return realfactory_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return realfactory_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return realfactory_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}	

	// to enable srcset
	if( !function_exists('realfactory_gdlr_core_enable_srcset') ){
		function realfactory_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = realfactory_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}
			
	// for goodlayers core pagination
	if( !function_exists('realfactory_gdlr_core_pagination_style') ){
		function realfactory_gdlr_core_pagination_style( $style ) {
			return realfactory_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('realfactory_gdlr_core_pagination_align') ){
		function realfactory_gdlr_core_pagination_align( $align ) {
			return realfactory_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('realfactory_gdlr_core_custom_post_slug') ){
		function realfactory_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = realfactory_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = realfactory_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = realfactory_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = realfactory_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = realfactory_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('realfactory_gdlr_core_portfolio_single_nav') ){
		function realfactory_gdlr_core_portfolio_single_nav( $check ) {
			return realfactory_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('realfactory_gdlr_core_portfolio_single_related') ){
		function realfactory_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = realfactory_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = realfactory_get_option('general', 'related-portfolio-style', 'grid');
				$args['num-fetch'] = realfactory_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['thumbnail-size'] = realfactory_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['excerpt-number'] = realfactory_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['column-size'] = realfactory_get_option('general', 'related-portfolio-column-size', 15);

				return $args;
			}else{
				return array();
			}
		}
	}

	// style the portfolio carousel nav
	add_filter('gdlr_core_block_item_title_only_carousel', 'realfactory_gdlr_core_block_item_title_only_carousel');
	if( !function_exists('realfactory_gdlr_core_block_item_title_only_carousel') ){
		function realfactory_gdlr_core_block_item_title_only_carousel( $carousel ){
			return 'disable';
		}
	}	

	// set default social share option
	if( !function_exists('realfactory_gdlr_core_social_share_list') ){
		function realfactory_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = realfactory_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = realfactory_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['google-plus'] = realfactory_get_option('general', 'blog-social-google-plus', $social['google-plus']);
			$social['pinterest'] = realfactory_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = realfactory_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = realfactory_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = realfactory_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'realfactory_register_custom_uploaded_font');
	if( !function_exists('realfactory_register_custom_uploaded_font') ){
		function realfactory_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = realfactory_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$custom_fonts[$font_option['name']] = array(
						'eot' => $font_option['eot'],
						'ttf' => $font_option['ttf'],
					);
				}
			}		
			
			return $custom_fonts;
			
		} // realfactory_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('realfactory_gdlr_core_widget_title_nav') ){
		function realfactory_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'realfactory_gdlr_core_page_builder_post_type');
	if( !function_exists('realfactory_gdlr_core_page_builder_post_type') ){
		function realfactory_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'realfactory_gdlr_core_lightbox_type');
	if( !function_exists('realfactory_gdlr_core_lightbox_type') ){
		function realfactory_gdlr_core_lightbox_type(){
			$lightbox_type = realfactory_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = realfactory_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'realfactory_lightbox_body_class');
	if( !function_exists('realfactory_lightbox_body_class') ){
		function realfactory_lightbox_body_class($class){
			$link_to_lightbox = realfactory_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}

	// add breadcrumbs option for portfolio
	add_filter('gdlr_core_portfolio_options', 'realfactory_gdlr_core_portfolio_options');
	if( !function_exists('realfactory_gdlr_core_portfolio_options') ){
		function realfactory_gdlr_core_portfolio_options($options){

			if( !empty($options['general']['options']) ){

				$general_first = array_slice($options['general']['options'], 0, 3, true); 
				$general_last = array_slice($options['general']['options'], 3, NULL, true);

				$options['general']['options'] = array_merge($general_first, array(
					'enable-breadcrumbs' => array(
						'title' => esc_html__('Enable Breadcrumbs ( Breadcrumb NavXT Plugin )', 'realfactory'),
						'type' => 'combobox',
						'options' => array(
							'default' => esc_html__('Default', 'realfactory'),
							'enable' => esc_html__('Enable', 'realfactory'),
							'disable' => esc_html__('Disable', 'realfactory'),
						),
						'default' => 'default',
						'condition' => array( 'enable-page-title' => 'enable' )
					),
				), $general_last);
			}

			return $options;
		}
	}

	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'realfactory_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'realfactory_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('realfactory_gdlr_core_page_builder_page_template_list') ){
		function realfactory_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['homepage-1'] = array(
				'title' => esc_html__('Homepage 1', 'realfactory'),
				'type' => 'wrapper',
			);
			$templates['homepage-2'] = array(
				'title' => esc_html__('Homepage 2', 'realfactory'),
				'type' => 'wrapper',
			);
			$templates['homepage-3'] = array(
				'title' => esc_html__('Homepage 3', 'realfactory'),
				'type' => 'wrapper',
			);
			$templates['homepage-4'] = array(
				'title' => esc_html__('Homepage 4', 'realfactory'),
				'type' => 'wrapper',
			);
			$templates['about-us-1'] = array(
				'title' => esc_html__('About Us 1', 'realfactory'),
				'type' => 'wrapper',
			);
			$templates['about-us-1'] = array(
				'title' => esc_html__('About Us 1', 'realfactory'),
				'type' => 'wrapper',
			);
			$templates['about-us-2'] = array(
				'title' => esc_html__('About Us 2', 'realfactory'),
				'type' => 'wrapper',
			);
			$templates['market-sector'] = array(
				'title' => esc_html__('Market Sector', 'realfactory'),
				'type' => 'wrapper',
			);
			return $templates;
		} // realfactory_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('realfactory_gdlr_core_page_builder_get_page_template') ){
		function realfactory_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'homepage-1': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2894","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2893","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"-100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Punctual Delivery Time","caption":"99% Delivered On Time","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"23px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"#0a0a0a","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2891","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"-100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"High Technology Factory","caption":"& Environment Friednly","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"23px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2892","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"-100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"High Standard Labors","caption":"99% QC Passed","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"23px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-15px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Real Factory\'s Story","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"106px","padding-bottom":"30px","icon-color":"","divider-color":"#d8a419"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2895","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2876","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Aenean lacinia bibendum nulla sed consectetur.","text-align":"left","font-size":"17px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"30px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#f8c12c","text-hover-color":"","background-color":"#303030","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"Get A Quote","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"13px","right":"30px","bottom":"13px","left":"30px","settings":"unlink"},"border2-radius":"3px","button2-background":"transparent","button2-border":"enable","border2-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text2-color":"#edbf2a","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#edbf2a","border2-hover-color":"#edbf2a","text-size":"13px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2896","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Call to action"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"We Won Many Factory Awards & Got Many Ceritificates Since 2001-2016","caption":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"26px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Market Sectors","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"enable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"55px"}},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2816","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/automotive-parts-system/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Automotive Parts & System","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/automotive-parts-system/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Real Factory\'s R&D Automotive applications are aimed at giving the company a competitive edge in the automotive market.","text-align":"left","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2421","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/construction-engineering/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Construction & Engineering","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/construction-engineering/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We provides a comprehensive range of products and techniques to create value for the construction industry and support sustainable development.","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2439","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/power-energy/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Power & Energy","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/power-energy/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"High quality material produced by Real Factory backed by support of our expert consultants to fulfill a whole range of applications in the market.","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2436","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/aero-space/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Aero Space","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/aero-space/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are a leading Aerospace steels manufacturer. Our special grade steels are being used in commercial and military aerospace projects.</p>","text-align":"left","font-size":"16px","padding-bottom":"20px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2441","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/ship-building-insudtry/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Ship Building Insudtry","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/ship-building-insudtry/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Real Factoryl is a major supplier of products to the ship building industry. We provide wide range of products in this industry.</p>","text-align":"left","font-size":"16px","padding-bottom":"20px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2448","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/railway/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Railway","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/railway/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We provides a wide range of high performance rail products and railway infrastructure services to the international rail industry.</p>","text-align":"left","font-size":"16px","padding-bottom":"20px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"300px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-port","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2897","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Featured EPC Works","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"24px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"2px","divider-width":"93px","padding-bottom":"40px","icon-color":"","divider-color":"#f8c12c"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We don\'t only sell products or parts but we are also a well known EPC contractor in the region.","text-align":"left","font-size":"16px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<a href=\"http://demo.goodlayers.com/realfactory/portfolio-3-columns/\">More Works [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"16px\" color=\"#fff\" margin-left=\"10px\" margin-right=\"\" ]</a>","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-port","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2898","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Portfolio Homepage"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":null,"tag":null,"num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"15","thumbnail-size":"Frame Port Portait","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation","excerpt":"none","excerpt-number":"55","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"18px","portfolio-title-font-weight":"600","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","padding-bottom":"10px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ececec","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Group\'s News","caption":"","caption-position":"top","title-link-text":"All News","title-link":"http://demo.goodlayers.com/realfactory/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#141414","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"3","prepend-sticky":"disable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-list","blog-full-alignment":"left","blog-list-with-frame":"enable","show-thumbnail":"enable","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","blog-title-font-size":"","blog-title-font-weight":"","blog-title-letter-spacing":"","blog-title-text-transform":"none","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"85px","right":"25px","bottom":"40px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Financial Results","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#141414","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2899","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2876","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Q2 2019 Press Release","link-url":"#","link-target":"_self"},{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Q2 2019 Presentation","link-url":"#","link-target":"_self"},{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"H2 2019 Half Year Financial Report","link-url":"#","link-target":"_self"}],"columns":"60","enable-divider":"enable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"#d8d8d8","icon-size":"16px","content-size":"15px","list-bottom-margin":"3px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"2900","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"35px","left":"56px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Career & Jobs","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"35px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Working at Real Factory means being able to commit resolutely to one thing and growing from it. As an individual and as a whole - in a family enterprise that creates fascinating products around the world. Once you experience it, you\'ll want to stay.","text-align":"left","font-size":"18px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Opened Positions","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"28px","bottom":"15px","left":"28px","settings":"unlink"},"border-radius":"3px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#f8c12c","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"15px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"655px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2901","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonials","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"87px","padding-bottom":"50px","icon-color":"","divider-color":""}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","caption":"","tabs":[{"title":"John Smith","position":"CEO Of Apple","content":"Nulla vitae elit libero, a pharetra augue. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Fusce dapibuNulla vitae elit libero, a pharetra augue. ","image":"2902","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-1.jpg"},{"title":"Alan Gordon","position":"Contractor","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Nulla vitae elit libero, a pharetra augue.","image":"2903","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-2.jpg"},{"title":"Janet Joles","position":"Purchasing Officer","content":"Cras mattis consectetur purus sit amet fermentum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus.","image":"2904","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-3.jpg"}],"style":"center","column":"1","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"bullet","title-size":"36px","caption-size":"16px","content-size":"21px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2905","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-1-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2906","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-2-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2907","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-3-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2908","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-4-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2909","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-5-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2910","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-6-150x150.jpg"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]}]';
				case 'homepage-2':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"3","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2893","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Punctual Delivery Time","caption":"99% Delivered On Time","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"23px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"#0a0a0a","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2891","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"High Technology Factory","caption":"& Environment Friednly","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"23px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2892","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"High Standard Labors","caption":"99% QC Passed","caption-position":"bottom","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"23px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"18px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2894","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Link"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2914","title":"The Safest Factory","caption":"","content":"tiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"40px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Link"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2915","title":"Smart Technology","caption":"","content":"tiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"42px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Link"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2916","title":"We Use Green Energy","caption":"","content":"tiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"40px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2917","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Featured EPC Works","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"26px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We don\'t only sell products or part but we are also a well-known<br />\nEPC contractor in the region.</p>\n","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<a href=\"http://demo.goodlayers.com/realfactory/portfolio-3-columns/\">More Works [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"16px\" color=\"#fff\" margin-left=\"15px\" margin-right=\"\" ]</a>","text-align":"right","font-size":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-port","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2898","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Portfolio Homepage"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":null,"tag":null,"num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"12","thumbnail-size":"Frame Port Portait","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation","excerpt":"none","excerpt-number":"55","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"18px","portfolio-title-font-weight":"300","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","padding-bottom":"10px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Market Sectors","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"enable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"55px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"2421","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"2918","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"157px","right":"20px","bottom":"60px","left":"73px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Call to action"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Construction & Engineering","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"26px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We provides a comprehensive range of products and techniques to create value for the construction industry and support sustainable development.</p>\n<p><a href=\"#\"><strong>Learn More</strong></a></p>\n","text-align":"left","font-size":"17px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"2919","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"157px","right":"40px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Service"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Railway","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"26px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We provides a wide range of high performance rail products and railway infrastructure services to the international rail industry.</p>\n<p><a href=\"#\"><strong>Learn More</strong></a></p>\n","text-align":"left","font-size":"17px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"2448","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"2439","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"2921","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"157px","right":"20px","bottom":"60px","left":"73px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Call to action"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Power & Energy","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"26px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>High quality material produced by Real Factory backed by support of our expert consultants to fulfill a whole range of applications in the enegy market.</p>\n<p><a href=\"#\"><strong>Learn More</strong></a></p>\n","text-align":"left","font-size":"17px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"2922","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"157px","right":"40px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Service"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Aero Space","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"26px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are a leading Aerospace steels manufacturer. Our special grade steels are being used in commercial and military aerospace projects around the world.</p>\n<p><a href=\"#\"><strong>Learn More</strong></a></p>\n","text-align":"left","font-size":"17px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"2437","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-15px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Real Factory\'s Story","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"30px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"75px","padding-bottom":"30px","icon-color":"","divider-color":"#e5e5e5"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. </p>\n<p>Ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Aenean lacinia bibendum nulla sed consectetur. Donec ullamcorper nulla non metus auctor fringilla. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh.</p>\n","text-align":"left","font-size":"17px","padding-bottom":"15px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"655px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2901","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonials","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"2px","divider-width":"87px","padding-bottom":"50px","icon-color":"","divider-color":""}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","caption":"","tabs":[{"title":"John Smith","position":"CEO Of Apple","content":"Nulla vitae elit libero, a pharetra augue. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Fusce dapibuNulla vitae elit libero, a pharetra augue. ","image":"2902","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-1.jpg"},{"title":"Alan Gordon","position":"Contractor","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Nulla vitae elit libero, a pharetra augue.","image":"2903","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-2.jpg"},{"title":"Janet Joles","position":"Purchasing Officer","content":"Cras mattis consectetur purus sit amet fermentum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus.","image":"2904","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-3.jpg"}],"style":"center","column":"1","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"bullet","title-size":"36px","caption-size":"16px","content-size":"21px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2905","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-1-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2906","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-2-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2907","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-3-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2908","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-4-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2909","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-5-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2910","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-6-150x150.jpg"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ececec","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"","background-image":"2900","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"55px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Career & Jobs","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"35px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Working at Real Factory means being able to commit resolutely to one thing and growing from it. As an individual and as a whole - in a family enterprise that creates fascinating products around the world. Once you experience it, you\'ll want to stay.","text-align":"left","font-size":"18px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Opened Positions","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"28px","bottom":"15px","left":"28px","settings":"unlink"},"border-radius":"3px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#f8c12c","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"15px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"10px","bottom":"40px","left":"25px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Financial Results","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#141414","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2899","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2876","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Q2 2019 Press Release","link-url":"#","link-target":"_self"},{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Q2 2019 Presentation","link-url":"#","link-target":"_self"},{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"H2 2019 Half Year Financial Report","link-url":"#","link-target":"_self"}],"columns":"60","enable-divider":"enable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"#d8d8d8","icon-size":"16px","content-size":"15px","list-bottom-margin":"3px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Group\'s News","caption":"","caption-position":"top","title-link-text":"All News","title-link":"http://demo.goodlayers.com/realfactory/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#141414","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"3","prepend-sticky":"disable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-list","blog-full-alignment":"left","blog-list-with-frame":"enable","show-thumbnail":"enable","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","blog-title-font-size":"","blog-title-font-weight":"","blog-title-letter-spacing":"","blog-title-text-transform":"none","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2896","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"70px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Call to action"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"We Won Many Factory Awards & Got Many Ceritificates Since 2001-2016","caption":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"26px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"0px"}}]}]';
				case 'homepage-3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"2","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#eab53a","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Service"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"We Won Many Factory Awards & Got Many Ceritificates Since 2001-2016","caption":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"26px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2927","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"170px","right":"70px","bottom":"110px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Aero Space","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"27px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We are a leading Aerospace steels manufacturer. Our special grade steels are being used in commercial and military aerospace projects around the world.","text-align":"left","font-size":"18px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2928","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#d8a734","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2929","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2924","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Aero Space Parts","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2421","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2930","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2924","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Construction Products","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2931","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"150px","right":"70px","bottom":"90px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Construction & Engineering","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"27px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We provides a comprehensive range of products and techniques to create value for the construction industry and support sustainable development.","text-align":"left","font-size":"18px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2933","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"150px","right":"70px","bottom":"90px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Railway","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"27px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We provides a wide range of high performance rail products and railway infrastructure services to the international rail industry.","text-align":"left","font-size":"18px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#000000","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2932","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2924","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Aero Space Parts","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"18px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-service","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2448","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2894","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.6","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Link"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2914","title":"The Safest Factory","caption":"","content":"tiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"40px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Link"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2915","title":"Smart Technology","caption":"","content":"tiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"42px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Yellow Link"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2916","title":"We Use Green Energy","caption":"","content":"tiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"21px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"17px","read-more-size":"16px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"40px","left":""},"title-top-padding":"","title-bottom-margin":"20px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2917","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Featured EPC Works","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"26px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We don\'t only sell products or part but we are also a well-known<br />\nEPC contractor in the region.</p>\n","text-align":"left","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<a href=\"http://demo.goodlayers.com/realfactory/portfolio-3-columns/\">More Works [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"16px\" color=\"#fff\" margin-left=\"15px\" margin-right=\"\" ]</a>","text-align":"right","font-size":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-port","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"","background-image":"2898","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Portfolio Homepage"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":null,"tag":null,"num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"12","thumbnail-size":"Frame Port Portait","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation","excerpt":"none","excerpt-number":"55","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"18px","portfolio-title-font-weight":"300","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","padding-bottom":"10px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2905","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-1-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2906","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-2-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2907","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-3-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2908","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-4-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2909","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-5-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2910","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-6-150x150.jpg"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"655px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2935","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"170px","right":"0px","bottom":"160px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We Won Many Factory Awards & Got  Many Ceritificates Since 2001-2016","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"34px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#141414","text-hover-color":"","background-color":"#e0b731","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","icon-size":"","button2-left-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#ececec","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"6px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Financial Results","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#141414","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"39px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Q2 2019 Press Release","link-url":"#","link-target":"_self"},{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Q2 2019 Presentation","link-url":"#","link-target":"_self"},{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"H2 2019 Half Year Financial Report","link-url":"#","link-target":"_self"}],"columns":"60","enable-divider":"enable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"#d8d8d8","icon-size":"16px","content-size":"15px","list-bottom-margin":"3px","padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2934","thumbnail-size":"Frame Lanscape","link-to":"none","custom-image":"","video-url":"","page-id":"2876","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"30px","bottom":"40px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Group\'s News","caption":"","caption-position":"top","title-link-text":"All News","title-link":"http://demo.goodlayers.com/realfactory/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#141414","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"55px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"3","prepend-sticky":"disable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-list","blog-full-alignment":"left","blog-list-with-frame":"enable","show-thumbnail":"enable","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","blog-title-font-size":"","blog-title-font-weight":"","blog-title-letter-spacing":"","blog-title-text-transform":"none","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"2900","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"0px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Career & Jobs","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"35px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Working at Real Factory means being able to commit resolutely to one thing and growing from it. As an individual and as a whole - in a family enterprise that creates fascinating products around the world. Once you experience it, you\'ll want to stay.","text-align":"left","font-size":"18px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Opened Positions","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"28px","bottom":"15px","left":"28px","settings":"unlink"},"border-radius":"3px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#f8c12c","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"15px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]}]}]';
				case 'homepage-4': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"2","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2937","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"55px","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Call To action 2"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"We Won Many Factory Awards & Got Many Ceritificates Since 2001-2016","caption":"","button-text":"Learn More","button-link":"#","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"26px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2816","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/automotive-parts-system/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Automotive Parts & System","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/automotive-parts-system/","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Real Factory\'s R&D Automotive applications","text-align":"center","font-size":"16px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2421","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/construction-engineering/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Construction & Engineering","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/construction-engineering/","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Provide comprehensive construction products","text-align":"center","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2439","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/power-energy/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Power & Energy","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/power-energy/","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"High quality material of renewable energy","text-align":"center","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2436","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/aero-space/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Aero Space","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/aero-space/","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We are a leading Aerospace steels manufacturer","text-align":"center","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2441","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/ship-building-insudtry/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Ship Building Insudtry","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/ship-building-insudtry/","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Real Factoryl is a major supplier of products","text-align":"center","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2448","thumbnail-size":"Frame Lanscape","link-to":"custom-url","custom-image":"","video-url":"","page-id":"2876","custom-url":"http://demo.goodlayers.com/realfactory/market-sectors/railway/","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"28","border-color":"","overlay-color":"#ecb622","overlay-icon-color":"#ffffff","overlay-background-opacity":"0.6","padding-bottom":"35px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Railway","caption":"","caption-position":"top","title-link-text":"","title-link":"http://demo.goodlayers.com/realfactory/market-sectors/railway/","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"20px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"10px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"We provides a high performance rail tools","text-align":"center","font-size":"16px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"2894","background-image-style":"repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"20px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Who Are We?","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"29px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2938","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2924","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Nullam id dolor id nibh ultricies vehicula ut id elit.","text-align":"left","font-size":"17px","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get A Quote","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"30px","bottom":"15px","left":"30px","settings":"unlink"},"border-radius":"3px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#f8c12c","text-hover-color":"","background-color":"#303030","background-hover-color":"","background-gradient-color":"","border-color":"#edbf2a","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"30px","bottom":"15px","left":"30px","settings":"unlink"},"border2-radius":"3px","button2-background":"transparent","button2-border":"enable","border2-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text2-color":"#edbf2a","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#edbf2a","border2-hover-color":"#edbf2a","text-size":"13px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why choose us?","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"29px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"Punctual Delivery Time","caption":"","content":"Donec ullamcorper nulla non metus auctor fringilla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ullamcorper nulla non metus auctor fringilla. Lorem ipsum dolor sit amet.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"#f8c12c","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"icon_clock_alt","icon-style":"normal","image":"2939","title":"Smart Technology","caption":"","content":"Donec ullamcorper nulla non metus auctor fringilla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ullamcorper nulla non metus auctor fringilla. Lorem ipsum dolor sit amet.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"#f8c12c","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"icon_clock_alt","icon-style":"normal","image":"2940","title":"Punctual Delivery Time","caption":"","content":"Donec ullamcorper nulla non metus auctor fringilla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ullamcorper nulla non metus auctor fringilla. Lorem ipsum dolor sit amet.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"19px","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"#f8c12c","icon-background":"","background-color":"","media-margin":{"top":"7px","right":"","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2941","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"90px","right":"0px","bottom":"25px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Featured EPC Works","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<a href=\"http://demo.goodlayers.com/realfactory/portfolio-3-columns/\">More Works [gdlr_core_icon icon=\"fa fa-long-arrow-right\" size=\"16px\" color=\"#fff\" margin-left=\"15px\" margin-right=\"\" ]</a>","text-align":"center","font-size":"","padding-bottom":"30px"}},{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"9","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-icon","column-size":"15","thumbnail-size":"Square","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"navigation","excerpt":"none","excerpt-number":"55","overlay-color":"","overlay-opacity":"","portfolio-title-font-size":"18px","portfolio-title-font-weight":"300","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","padding-bottom":"10px","title-align":"center","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"45px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2905","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-1-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2906","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-2-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2907","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-3-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2908","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-4-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2909","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-5-150x150.jpg"},{"link-to":"custom-url","custom-image":"","video-url":"","page-id":"42","custom-url":"#","custom-link-target":"_self","id":"2910","thumbnail":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/banner-6-150x150.jpg"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"carousel","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"none","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width":"655px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2942","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonials","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"200","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#0a0a0a","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","caption":"","tabs":[{"title":"John Smith","position":"CEO Of Apple","content":"Nulla vitae elit libero, a pharetra augue. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Fusce dapibuNulla vitae elit libero, a pharetra augue. ","image":"2902","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-1.jpg"},{"title":"Alan Gordon","position":"Contractor","content":"Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Nulla vitae elit libero, a pharetra augue.","image":"2903","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-2.jpg"},{"title":"Janet Joles","position":"Purchasing Officer","content":"Cras mattis consectetur purus sit amet fermentum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus.","image":"2904","image-img":"http://demo.goodlayers.com/realfactory/wp-content/uploads/2016/06/testimonial-3.jpg"}],"style":"center","column":"1","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"bullet","title-size":"36px","caption-size":"16px","content-size":"21px","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blog Homepage"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Group\'s News","caption":"","caption-position":"top","title-link-text":"All News","title-link":"http://demo.goodlayers.com/realfactory/blog-full-right-sidebar-with-frame/","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#141414","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"3","prepend-sticky":"disable","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-list","blog-full-alignment":"left","blog-list-with-frame":"enable","show-thumbnail":"enable","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-autoslide":"enable","carousel-navigation":"navigation","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","blog-title-font-size":"","blog-title-font-weight":"","blog-title-letter-spacing":"","blog-title-text-transform":"none","padding-bottom":"30px","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"25px","bottom":"40px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Financial Results","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#141414","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"45px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2899","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2876","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"25px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Q2 2019 Press Release","link-url":"#","link-target":"_self"},{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Q2 2019 Presentation","link-url":"#","link-target":"_self"},{"icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"H2 2019 Half Year Financial Report","link-url":"#","link-target":"_self"}],"columns":"60","enable-divider":"enable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"#d8d8d8","icon-size":"16px","content-size":"15px","list-bottom-margin":"3px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-financial","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"","background-image":"2900","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"95px","right":"0px","bottom":"0px","left":"56px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Career & Jobs","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"35px","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#f8c12c","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"40px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Working at Real Factory means being able to commit resolutely to one thing and growing from it. As an individual and as a whole - in a family enterprise that creates fascinating products around the world. Once you experience it, you\'ll want to stay.","text-align":"left","font-size":"18px","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"See Opened Positions","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"28px","bottom":"15px","left":"28px","settings":"unlink"},"border-radius":"3px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#f8c12c","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"15px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]}]}]';
				case 'about-us-1': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"left","background-color":"#f1f0f0","background-image":"2864","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"110px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Pharetra Etiam Inceptos","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"33px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia.</p>","text-align":"left","font-size":"17px","padding-bottom":"15px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Vestibulum id ligula","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Mattis Fringilla Ultricies","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Egestas Fermentum","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Adipiscing Vulputate","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Ultricies Bibendum","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Fringilla Quam Elit","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Fermentum Tellus","link-url":"","link-target":"_self"},{"icon":"fa fa-check-circle","icon-hover":"fa fa-check-circle","title":"Commodo Vestibulum","link-url":"","link-target":"_self"}],"columns":"30","enable-divider":"disable","icon-background":"none","icon-color":"","icon-background-color":"","content-color":"","border-color":"","icon-size":"16px","content-size":"16px","list-bottom-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"left","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"135px","right":"80px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Real Factory\'s Story","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.</p><p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque ornare sem lacinia quam</p>","text-align":"left","font-size":"18px","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get A Quote","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"28px","bottom":"15px","left":"28px","settings":"unlink"},"border-radius":"3px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#111111","text-hover-color":"#f8c12c","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","icon-size":"","button2-left-margin":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"color","background-extending":"right","background-color":"#1f1f1f","background-image":"2181","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"30px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2867","title":"Ornare Quam Justo Tellusv","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. </p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"40px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2868","title":"Pellentesque Magna Venenatis","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. </p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"45px","bottom":"","left":"5px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2869","title":"Magna Nibh Commodo","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. </p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"49px","bottom":"0px","left":"13px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"109px","right":"80px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Amet Etiam Quam","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Vestibulum id ligula porta felis euismod semper. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Maecenas sed diam eget risus varius blandit sit amet non magna. Maecenas sed diam eget risus varius blandit sit amet non magna. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec id elit non mi porta gravida.","text-align":"left","font-size":"15px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Material Productions","icon":"","percent":"90","bar-text":""},{"heading-text":"EPC Works","icon":"","percent":"100","bar-text":""},{"heading-text":"Customer Satisfaction","icon":"","percent":"85","bar-text":""},{"heading-text":"Utilization Rate","icon":"","percent":"90","bar-text":""}],"heading-text-color":"","icon-color":"","percent-color":"","bar-filled-color":"","bar-background-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#232323","background-image":"2871","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Important <span style=\"color: #f8c12c;\">Static</span>","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"54px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings<br />\nof spring which I enjoy with my whole heart. I am alone</p>\n","text-align":"center","font-size":"16px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"20000","animation-time":"4000","suffix":"+","divider":"disable","bottom-text":"Customers","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"1400","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"16800","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"17000","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"SKUs","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet The Team","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"45px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"60px"}},{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"6","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid-with-background","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"disable","column-size":"3","thumbnail-size":"Frame Landscape 2","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"enable","carousel-navigation":"navigation","padding-bottom":"30px","title-align":"center","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":""}}]}]';
				case 'about-us-2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#0a0a0a","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"60px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2878","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2841","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"New Technology","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","text-align":"center","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#242424","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"60px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2879","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2841","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"High Grade Tools","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","text-align":"center","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#e6b356","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"60px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2880","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2841","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Green Energy","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","text-align":"center","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#d3a04e","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"80px","right":"60px","bottom":"60px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2881","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2841","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Pollution Free","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h4","title-font-size":"23px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","text-align":"center","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"left","background-color":"#f2f2f2","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"135px","right":"80px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Real Factory\'s Story","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"36px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.</p><p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque ornare sem lacinia quam</p>","text-align":"left","font-size":"18px","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get A Quote","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"28px","bottom":"15px","left":"28px","settings":"unlink"},"border-radius":"3px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#111111","text-hover-color":"#f8c12c","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","text2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","text-size":"14px","icon-size":"","button2-left-margin":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"right","background-color":"#1f1f1f","background-image":"2877","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"30px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2867","title":"Ornare Quam Justo Tellusv","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. </p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"40px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2868","title":"Pellentesque Magna Venenatis","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. </p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"45px","bottom":"","left":"5px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2869","title":"Magna Nibh Commodo","caption":"","content":"<p>Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. </p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","title-size":"21px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","content-size":"16px","read-more-size":"14px","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"49px","bottom":"0px","left":"13px"},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"109px","right":"20px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Etiam Vehicula Euismod  Fusce Fermentum","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"28px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"3px","divider-width":"95px","padding-bottom":"30px","icon-color":"","divider-color":"#f8c12c"}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"105px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Vestibulum id ligula porta felis euismod semper. Cras mattis consectetur purus sit amet fermentum. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.Ligula Dolor.</p>\n<p>Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam id dolor id nibh ultricies vehicula ut id elit. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nullam id dolor id nibh ultricies vehicula ut id elit.</p>\n","text-align":"left","font-size":"18px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"#232323","background-image":"2884","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"75px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"call-to-action","value":{"id":"","class":"","title":"We Won Many Factory Awards & Got Many Ceritificates Since 2001-2016","caption":"","button-text":"Buy Now","button-link":"#","button-link-target":"_self","style":"left-align-right-button","button-style":"solid","button-border-radius":"3px","title-size":"26px","title-font-weight":"300","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"19px","caption-letter-spacing":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#2b2b2b","background-image":"2871","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"130px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Dark"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"20000","animation-time":"4000","suffix":"+","divider":"disable","bottom-text":"Customers","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"1400","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"16800","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#2e84c2","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"About Counter"},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-users","top-text":"","prefix":"","start-number":"0","end-number":"17000","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"SKUs","top-icon-size":"55px","top-text-size":"16px","number-size":"49px","bottom-text-size":"18px","bottom-text-transform":"none","padding-bottom":"10px"}}]}]}]';
				case 'market-sector': 
					return '[{"template":"wrapper","type":"sidebar","value":{"id":"","class":"","content-layout":"boxed","sidebar":"left","sidebar-left":"market-sectors","sidebar-right":"footer-1","sidebar-width":"15","hide-this-wrapper-in":"none","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding":{"top":"60px","right":"0px","bottom":"30px","left":"30px","settings":"unlink"},"background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","sidebar-padding":{"top":"60px","right":"30px","bottom":"30px","left":"0px","settings":"unlink"},"sidebar-background-color":"#f9f9f9","sidebar-skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2807","thumbnail-size":"Frame Long","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2804","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"40px"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"10px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Automotive Parts & System","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"27px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"#181818","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Download Doc","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"left","icon":"fa fa-file-word-o","text-align":"right","full-width-button":"disable","button-padding":{"top":"12px","right":"20px","bottom":"12px","left":"20px","settings":"unlink"},"border-radius":"3px","button-background":"transparent","button-border":"enable","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text-color":"#353535","text-hover-color":"#f8c12c","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#f8c12c","border-hover-color":"","button2-text":"Download PDF","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"#","button2-link-target":"_self","button2-icon-position":"left","button2-icon":"fa fa-file-pdf-o","button2-padding":{"top":"12px","right":"20px","bottom":"12px","left":"20px","settings":"unlink"},"border2-radius":"3px","button2-background":"transparent","button2-border":"enable","border2-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"text2-color":"#303030","text2-hover-color":"#f8c12c","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#f8c12c","border2-hover-color":"","text-size":"13px","icon-size":"","button2-left-margin":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Aenean lacinia bibendum nulla sed consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nulla vitae elit libero, a pharetra augue. Sed posuere consectetur est at lobortis. Sed posuere consectetur est at lobortis.</p>","text-align":"left","font-size":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"36","items":[{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"title":"Mollis Pharetra Euismod Tellus Fermentum","content":"Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque o.rnare sem lacinia quam."},{"title":"Vulputate Sem Pellentesque Adipiscing","content":"Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque o.rnare sem lacinia quam."},{"title":"Cursus Sit Tortor Ligula Nullam","content":"Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque o.rnare sem lacinia quam."},{"title":"Fermentum Vestibulum Purus","content":"Etiam porta sem malesuada magna mollis euismod. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Aenean lacinia. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Aenean eu leo quam. Pellentesque o.rnare sem lacinia quam."}],"active":"1","style":"box-icon","align":"left","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2806","thumbnail-size":"Frame Blog Full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2804","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2816","thumbnail-size":"Frame Blog Full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2804","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2817","thumbnail-size":"Frame Blog Full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2804","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Cras justo odio, dapibus ac facilisis in, egestas eget quam. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Nulla vitae elit libero, a pharetra augue. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Sed posuere consectetur est at lobortis. Nullam id dolor id nibh ultricies vehicula ut id elit.</p>","text-align":"left","font-size":"","padding-bottom":"20px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Sem Aenean Pharetra","caption":"","caption-position":"top","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"24px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Sed posuere consectetur est at lobortis. Aenean lacinia bibendum nulla sed consectetur. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Vestibulum id ligula porta felis euismod semper. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Vestibulum id ligula porta felis euismod semper. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Maecenas faucibus mollis interdum. Donec sed odio dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>","text-align":"left","font-size":"","padding-bottom":"30px"}},{"template":"element","type":"social-share","value":{"id":"","class":"","facebook":"enable","linkedin":"enable","google-plus":"enable","pinterest":"enable","stumbleupon":"enable","twitter":"enable","email":"enable","social-head":"none","social-head-text":"Social Shares","layout":"left-text","text-align":"left","icon-size":"18px","text-color":"","icon-color":"","divider-color":"","padding-bottom":"30px"}}]}]}]';
				}

		} // realfactory_gdlr_core_page_builder_get_page_template
	} // function_exists